% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{scatter}
\alias{scatter}
\title{Scatter Plot Functions}
\usage{
scatter(object, ...)
}
\arguments{
\item{object}{An object of nsga-class, nsga2-class or nsga3-class.
See \linkS4class{nsga}, \linkS4class{nsga2} or \linkS4class{nsga3} for a description of
available slots information.}

\item{...}{Other arguments passed on to methods. Used to pass the \code{optimal}
value of the objective function, in case of having it.}
}
\description{
Allows to make scatter plots in publication quality allowing
to represent 2-D, 3-D and M-D
}
\examples{
#Two Objectives Plotting
zdt1 <- function (x) {
 if (is.null(dim(x))) {
   x <- matrix(x, nrow = 1)
 }
 n <- ncol(x)
 g <- 1 + rowSums(x[, 2:n, drop = FALSE]) * 9/(n - 1)
 return(cbind(x[, 1], g * (1 - sqrt(x[, 1]/g))))
}

#Not run
\dontrun{
result <- nsga3(type = "real-valued",
                fitness = zdt1,
                lower = c(0,0),
                upper = c(1,1),
                popSize = 100,
                n_partitions = 100,
                monitor = FALSE,
                maxiter = 500)
}
#Not run
\dontrun{
scatter(object = result)
}

}
\author{
Francisco Benitez
\email{benitezfj94@gmail.com}
}
