% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expression.R
\name{ArrayAccess}
\alias{ArrayAccess}
\title{Array Access}
\description{
Create ArrayAccess elements in MiniZinc
}
\examples{
vDecl1 = IntSetDecl(name = "SET", kind = "par")
vDecl2 = IntArrDecl(name = "profit", kind = "par", ndim = 1, 
ind = list(vDecl1$getId()))
newArrayAccess = ArrayAccess$new(v = vDecl2$getId(),
 args = list(IntDecl(name = "i", kind = "par")))
}
\section{Super class}{
\code{\link[rminizinc:Expression]{rminizinc::Expression}} -> \code{ArrayAccess}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.v}}{the id/value of array}

\item{\code{.args}}{arguments of the array}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.v}}{the id/value of array}

\item{\code{.args}}{arguments of the array}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ArrayAccess$new()}}
\item \href{#method-getV}{\code{ArrayAccess$getV()}}
\item \href{#method-setV}{\code{ArrayAccess$setV()}}
\item \href{#method-nargs}{\code{ArrayAccess$nargs()}}
\item \href{#method-getArgs}{\code{ArrayAccess$getArgs()}}
\item \href{#method-setArgs}{\code{ArrayAccess$setArgs()}}
\item \href{#method-c_str}{\code{ArrayAccess$c_str()}}
\item \href{#method-getDeleteFlag}{\code{ArrayAccess$getDeleteFlag()}}
\item \href{#method-delete}{\code{ArrayAccess$delete()}}
\item \href{#method-clone}{\code{ArrayAccess$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArrayAccess$new(v, args)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{the value/identifier of variable decl}

\item{\code{args}}{the array indices}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getV"></a>}}
\if{latex}{\out{\hypertarget{method-getV}{}}}
\subsection{Method \code{getV()}}{
get the array access value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArrayAccess$getV()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setV"></a>}}
\if{latex}{\out{\hypertarget{method-setV}{}}}
\subsection{Method \code{setV()}}{
set the array access value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArrayAccess$setV(val)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{val}}{new array access value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nargs"></a>}}
\if{latex}{\out{\hypertarget{method-nargs}{}}}
\subsection{Method \code{nargs()}}{
get the number of arguments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArrayAccess$nargs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getArgs"></a>}}
\if{latex}{\out{\hypertarget{method-getArgs}{}}}
\subsection{Method \code{getArgs()}}{
get the arguments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArrayAccess$getArgs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setArgs"></a>}}
\if{latex}{\out{\hypertarget{method-setArgs}{}}}
\subsection{Method \code{setArgs()}}{
set the arguments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArrayAccess$setArgs(val)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{val}}{new arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c_str"></a>}}
\if{latex}{\out{\hypertarget{method-c_str}{}}}
\subsection{Method \code{c_str()}}{
return the MiniZinc representation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArrayAccess$c_str()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDeleteFlag"></a>}}
\if{latex}{\out{\hypertarget{method-getDeleteFlag}{}}}
\subsection{Method \code{getDeleteFlag()}}{
delete flag for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArrayAccess$getDeleteFlag()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
delete the assignment item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArrayAccess$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ArrayAccess$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
