/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array.loader.fileLoader;

import dmLab.array.functions.DiscFunctions;
import dmLab.array.loader.fileLoader.FileLoader;
import dmLab.array.meta.Attribute;
import dmLab.array.meta.AttributeDef;
import dmLab.utils.MyString;
import java.io.BufferedReader;
import java.io.File;

public final class FileLoaderADX
extends FileLoader {
    private boolean allDecision = false;

    @Override
    protected final boolean myInit() {
        this.separator = (char)44;
        this.nullLabels.clear();
        this.nullLabels.add("");
        this.nullLabels.add("?");
        this.nullLabels.add("NaN");
        this.nullLabels.add("NA");
        this.nullLabels.add("Null");
        this.commentChar = "#";
        this.fileType = 0;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean parseInputFile(File inputFile) {
        String line;
        boolean attributeSection = false;
        boolean eventSection = false;
        boolean bracketOpen = false;
        int lineCount = 0;
        BufferedReader fileReader = DiscFunctions.openFile(inputFile);
        if (fileReader == null) {
            DiscFunctions.closeFile(fileReader);
            return false;
        }
        do {
            void var1_2;
            try {
                line = fileReader.readLine();
                ++lineCount;
            }
            catch (Exception exception) {
                System.err.println("Error reading input file.");
                return false;
            }
            if (line == null || (line = this.trimComments(line)).equalsIgnoreCase("")) continue;
            if ((line.toLowerCase().indexOf("attributes") != -1 || line.toLowerCase().indexOf("events") != -1) && line.toLowerCase().indexOf("{") != -1) {
                if (line.toLowerCase().indexOf("attributes") > line.toLowerCase().indexOf("{")) {
                    System.err.println("Bracket Before Declaration of 'attributes' section! Line: " + String.valueOf(lineCount));
                    return false;
                }
                if (line.toLowerCase().indexOf("attributes") != -1) {
                    attributeSection = true;
                    bracketOpen = true;
                }
                if (line.toLowerCase().indexOf("events") > line.toLowerCase().indexOf("{")) {
                    System.err.println("Bracket Before Declaration of 'events' section! Line: " + String.valueOf(lineCount));
                    return false;
                }
                if (line.toLowerCase().indexOf("events") != -1) {
                    eventSection = true;
                    bracketOpen = true;
                }
            } else {
                if (line.toLowerCase().indexOf("attributes") != -1) {
                    attributeSection = true;
                } else if (line.toLowerCase().indexOf("events") != -1) {
                    eventSection = true;
                }
                if (line.toLowerCase().indexOf("{") != -1 && !attributeSection && !eventSection) {
                    System.err.println("Unexpected Bracket Opening! Line: " + String.valueOf(lineCount));
                    return false;
                }
                if (line.toLowerCase().indexOf("}") != -1 && !attributeSection && !eventSection) {
                    System.err.println("Unexpected Bracket Closing! Line " + String.valueOf(lineCount));
                    return false;
                }
                if (line.toLowerCase().indexOf("{") != -1 && (attributeSection || eventSection)) {
                    bracketOpen = true;
                } else if (line.toLowerCase().equalsIgnoreCase("}") && (attributeSection || eventSection)) {
                    bracketOpen = false;
                    attributeSection = false;
                    eventSection = false;
                }
            }
            if (!bracketOpen) continue;
            int startLine = line.indexOf("{") + 1;
            int stopLine = line.indexOf("}");
            if (startLine == -1) {
                startLine = 0;
            }
            if (stopLine == -1) {
                stopLine = line.length();
            }
            if (startLine == stopLine) continue;
            if (attributeSection) {
                if (!line.substring(startLine, stopLine).equalsIgnoreCase("")) {
                    if (line.indexOf("ignore") == -1) {
                        ++this.attributesNumber;
                    } else {
                        ++this.ignoredAttributesNumber;
                    }
                }
                if (line.endsWith("}")) {
                    bracketOpen = false;
                    attributeSection = false;
                }
            }
            if (!eventSection) continue;
            if (!line.substring((int)var1_2, stopLine).equalsIgnoreCase("")) {
                ++this.eventsNumber;
            }
            if (!line.endsWith("}")) continue;
            bracketOpen = false;
            eventSection = false;
        } while (line != null);
        return DiscFunctions.closeFile(fileReader);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean readInputFile(File inputFile) {
        String line;
        int attrIndex = 0;
        int eventIndex = 0;
        boolean attributeSection = false;
        boolean eventSection = false;
        boolean bracketOpen = false;
        int lineCount = 0;
        int attributeCount = 0;
        BufferedReader fileReader = DiscFunctions.openFile(inputFile);
        if (fileReader == null) {
            return false;
        }
        do {
            void var1_2;
            try {
                line = fileReader.readLine();
                ++lineCount;
            }
            catch (Exception exception) {
                System.err.println("Error reading input file.");
                return false;
            }
            if (line == null || (line = this.trimComments(line)).equalsIgnoreCase("")) continue;
            if (line.toLowerCase().indexOf("attributes") != -1) {
                attributeSection = true;
            } else if (line.toLowerCase().indexOf("events") != -1) {
                eventSection = true;
            }
            if (line.toLowerCase().indexOf("{") != -1 && (attributeSection || eventSection)) {
                bracketOpen = true;
            } else if (line.toLowerCase().equalsIgnoreCase("}") && (attributeSection || eventSection)) {
                bracketOpen = false;
                attributeSection = false;
                eventSection = false;
            }
            if (!bracketOpen) continue;
            int startLine = line.indexOf("{") + 1;
            int stopLine = line.indexOf("}");
            if (startLine == -1) {
                startLine = 0;
            }
            if (stopLine == -1) {
                stopLine = line.length();
            }
            if (startLine == stopLine) continue;
            if (attributeSection) {
                if (line.substring(startLine, stopLine).endsWith("ignore")) {
                    this.ignoredAttributeMask[attributeCount++] = true;
                } else {
                    boolean bl;
                    int n = attrIndex;
                    Object object = line.substring(startLine, stopLine);
                    FileLoaderADX fileLoaderADX = this;
                    if ((object = FileLoaderADX.parseAttribute((String)object)) == null) {
                        bl = false;
                    } else {
                        fileLoaderADX.myArray.attributes[n] = object;
                        if (((AttributeDef)object).role == AttributeDef.ROLE_DECISION) {
                            fileLoaderADX.myArray.setDecAttrIdx(n);
                            if (((AttributeDef)object).decValues != null && ((AttributeDef)object).decValues.length > 0) {
                                fileLoaderADX.myArray.setDecValues(((AttributeDef)object).decValues);
                            } else {
                                fileLoaderADX.allDecision = true;
                            }
                        }
                        bl = true;
                    }
                    if (!bl) {
                        System.err.println("Error reading attribute! Line: " + lineCount);
                        return false;
                    }
                    this.ignoredAttributeMask[attributeCount++] = false;
                    ++attrIndex;
                }
                if (line.endsWith("}")) {
                    bracketOpen = false;
                    attributeSection = false;
                }
            }
            if (!eventSection) continue;
            if (!this.loadEvent(line.substring((int)var1_2, stopLine), eventIndex)) {
                System.err.println("Error reading event. Line: " + lineCount);
                return false;
            }
            if (line.endsWith("}")) {
                bracketOpen = false;
                eventSection = false;
            }
            ++eventIndex;
        } while (line != null);
        if (this.allDecision) {
            this.myArray.setAllDecValues();
        }
        return DiscFunctions.closeFile(fileReader);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static AttributeDef parseAttribute(String inputString) {
        void var1_1;
        AttributeDef attr = new AttributeDef();
        String[] list = DiscFunctions.tokenize(inputString, new char[]{' ', '\t'}, new char[]{'\"', '\''});
        if (list.length == 4) {
            if (!list[2].equalsIgnoreCase("decision")) {
                System.err.println("Incorrect definition of the attribute (should be: 'name type role'). There is: " + inputString);
                return null;
            }
            list[2] = String.valueOf(list[2]) + list[3];
        }
        int i = 0;
        while (i < list.length) {
            String[] s;
            String[] label = list[i];
            if (i == 0) {
                s = new MyString((String)label);
                s.remove('\'');
                s.remove('\"');
                attr.name = s.toString();
            } else if (i == 1) {
                if (Attribute.type2Int((String)s) == -1) {
                    System.err.println("Incorrect type of attribute: " + list[0] + " type: " + (String)s);
                    return null;
                }
                attr.type = Attribute.type2Int((String)s);
            } else if (i == 2) {
                if (s.equalsIgnoreCase("ignore")) {
                    attr.role = 0;
                } else {
                    String[] stringArray;
                    if (!s.toLowerCase().startsWith("decision")) {
                        System.err.println("Incorrect role of attribute: " + list[0] + " role: " + (String)stringArray);
                        return null;
                    }
                    attr.role = AttributeDef.ROLE_DECISION;
                    String[] decisionValues = FileLoaderADX.parseDecValues((String)s, ',');
                    if (decisionValues == null) {
                        return null;
                    }
                    attr.decValues = stringArray;
                }
            }
            ++i;
        }
        if (attr.type == 0) {
            void var2_2;
            System.err.println("Type is not defined for attribute: " + (String)var2_2[0]);
            return null;
        }
        return var1_1;
    }

    private static String[] parseDecValues(String inputString, char separator) {
        Object object;
        if (inputString.trim().equalsIgnoreCase("decision")) {
            return new String[0];
        }
        if (inputString.indexOf("(") == -1 || inputString.indexOf(")") == -1) {
            System.err.println("Missing bracket!");
            return null;
        }
        if (inputString.indexOf(")") < inputString.indexOf("(")) {
            System.err.println("Unexpected bracket closing.");
            return null;
        }
        Object valuesString = inputString.substring(inputString.indexOf("(") + 1, inputString.indexOf(")")).trim();
        if (valuesString.length() == 0) {
            System.err.println("Decision values are not defined.");
            return null;
        }
        Object decValues = DiscFunctions.tokenizeString((String)valuesString, new char[]{','}, false);
        if (((String[])decValues).length == 1 && decValues[0].equalsIgnoreCase("all")) {
            return new String[0];
        }
        int i = 0;
        while (i < ((String[])decValues).length) {
            if (decValues[i].length() == 0) {
                System.err.println("Missing decision value!");
                return null;
            }
            ++i;
        }
        return object;
    }

    @Override
    protected final boolean readHeaderFile(File inputFile) {
        return true;
    }

    @Override
    protected final File getDataFile(File inputFile) {
        return inputFile;
    }
}

