% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/list.map.R
\name{list.mapv}
\alias{list.mapv}
\title{Map each member of a list by an expression to a vector.}
\usage{
list.mapv(.data, expr, as, use.names = TRUE)
}
\arguments{
\item{.data}{a \code{list} or \code{vector}}

\item{expr}{a lambda expression}

\item{as}{the mode to corece. Missing to \code{unlist}
the mapped results.}

\item{use.names}{Should the names of the results be preserved?}
}
\value{
A \code{vector} in which each element is mapped by \code{expr} in \code{.data}
}
\description{
Map each member of a list by an expression to a vector.
}
\examples{
x <- list(p1 = list(type='A',score=list(c1=10,c2=8)),
       p2 = list(type='B',score=list(c1=9,c2=9)),
       p3 = list(type='B',score=list(c1=9,c2=7)))
list.mapv(x, type)
list.mapv(x, min(score$c1,score$c2))
}
\seealso{
\code{\link{list.map}}
}

