% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{calcAgreement}
\alias{calcAgreement}
\title{Calculate agreement metric after integration}
\usage{
calcAgreement(
  object,
  ndims = 40,
  nNeighbors = 15,
  useRaw = FALSE,
  byDataset = FALSE,
  seed = 1,
  dr.method = NULL,
  k = nNeighbors,
  use.aligned = NULL,
  rand.seed = seed,
  by.dataset = byDataset
)
}
\arguments{
\item{object}{\code{liger} object. Should call \code{\link{alignFactors}}
before calling.}

\item{ndims}{Number of factors to produce in NMF. Default \code{40}.}

\item{nNeighbors}{Number of nearest neighbors to use in calculating Jaccard
index. Default \code{15}.}

\item{useRaw}{Whether to evaluate just factorized \eqn{H} matrices instead of
using aligned \eqn{H.norm} matrix. Default \code{FALSE} uses
aligned matrix.}

\item{byDataset}{Whether to return agreement calculated for each dataset
instead of the average for all datasets. Default \code{FALSE}.}

\item{seed}{Random seed to allow reproducible results. Default \code{1}.}

\item{dr.method}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#defunct}{\figure{lifecycle-defunct.svg}{options: alt='[Defunct]'}}}{\strong{[Defunct]}} We no longer support other
methods but just NMF.}

\item{k, rand.seed, by.dataset}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} See Usage
for replacement.}

\item{use.aligned}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} Use \code{useRaw}
instead.}
}
\value{
A numeric vector of agreement metric. A single value if
\code{byDataset = FALSE} or each dataset a value otherwise.
}
\description{
This metric quantifies how much the factorization and alignment distorts the
geometry of the original datasets. The greater the agreement, the less
distortion of geometry there is. This is calculated by performing
dimensionality reduction on the original and integrated (factorized or plus
aligned) datasets, and measuring similarity between the k nearest
neighbors for each cell in original and integrated datasets. The Jaccard
index is used to quantify similarity, and is the final metric averages across
all cells.

Note that for most datasets, the greater the chosen \code{nNeighbor}, the
greater the agreement in general. Although agreement can theoretically
approach 1, in practice it is usually no higher than 0.2-0.3.
}
\examples{
if (requireNamespace("RcppPlanc", quietly = TRUE)) {
    pbmc <- pbmc \%>\%
    normalize \%>\%
    selectGenes \%>\%
    scaleNotCenter \%>\%
    runINMF \%>\%
    alignFactors
    calcAgreement(pbmc)
}
}
