% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cINMF.R
\name{runCINMF}
\alias{runCINMF}
\alias{runCINMF.liger}
\alias{runCINMF.Seurat}
\title{Perform consensus iNMF on scaled datasets}
\usage{
runCINMF(object, k = 20, lambda = 5, rho = 0.3, ...)

\method{runCINMF}{liger}(
  object,
  k = 20,
  lambda = 5,
  rho = 0.3,
  nIteration = 30,
  nRandomStarts = 10,
  HInit = NULL,
  WInit = NULL,
  VInit = NULL,
  seed = 1,
  nCores = 2L,
  verbose = getOption("ligerVerbose", TRUE),
  ...
)

\method{runCINMF}{Seurat}(
  object,
  k = 20,
  lambda = 5,
  rho = 0.3,
  datasetVar = "orig.ident",
  layer = "ligerScaleData",
  assay = NULL,
  reduction = "cinmf",
  nIteration = 30,
  nRandomStarts = 10,
  HInit = NULL,
  WInit = NULL,
  VInit = NULL,
  seed = 1,
  nCores = 2L,
  verbose = getOption("ligerVerbose", TRUE),
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object or a Seurat object with
non-negative scaled data of variable features (Done with
\code{\link{scaleNotCenter}}).}

\item{k}{Inner dimension of factorization (number of factors). Generally, a
higher \code{k} will be needed for datasets with more sub-structure. Default
\code{20}.}

\item{lambda}{Regularization parameter. Larger values penalize
dataset-specific effects more strongly (i.e. alignment should increase as
\code{lambda} increases). Default \code{5}.}

\item{rho}{Numeric number between 0 and 1. Fraction for determining the
number of nearest neighbors to look at for consensus (by
\code{rho * nRandomStarts}). Default \code{0.3}.}

\item{...}{Arguments passed to methods.}

\item{nIteration}{Total number of block coordinate descent iterations to
perform. Default \code{30}.}

\item{nRandomStarts}{Number of replicate runs for creating the pool of
factorization results. Default \code{10}.}

\item{HInit}{Initial values to use for \eqn{H} matrices. A list object where
each element is the initial \eqn{H} matrix of each dataset. Default
\code{NULL}.}

\item{WInit}{Initial values to use for \eqn{W} matrix. A matrix object.
Default \code{NULL}.}

\item{VInit}{Initial values to use for \eqn{V} matrices. A list object where
each element is the initial \eqn{V} matrix of each dataset. Default
\code{NULL}.}

\item{seed}{Random seed to allow reproducible results. Default \code{1}.}

\item{nCores}{The number of parallel tasks to speed up the computation.
Default \code{2L}. Only supported for platform with OpenMP support.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{datasetVar}{Metadata variable name that stores the dataset source
annotation. Default \code{"orig.ident"}.}

\item{layer}{For Seurat>=4.9.9, the name of layer to retrieve input
non-negative scaled data. Default \code{"ligerScaleData"}. For older Seurat,
always retrieve from \code{scale.data} slot.}

\item{assay}{Name of assay to use. Default \code{NULL} uses current active
assay.}

\item{reduction}{Name of the reduction to store result. Also used as the
feature key. Default \code{"cinmf"}.}
}
\value{
\itemize{
 \item{liger method - Returns updated input \linkS4class{liger} object
 \itemize{
     \item{A list of all \eqn{H} matrices can be accessed with
         \code{getMatrix(object, "H")}}
     \item{A list of all \eqn{V} matrices can be accessed with
         \code{getMatrix(object, "V")}}
     \item{The \eqn{W} matrix can be accessed with
         \code{getMatrix(object, "W")}}
 }}
 \item{Seurat method - Returns updated input Seurat object
 \itemize{
     \item{\eqn{H} matrices for all datasets will be concatenated and
         transposed (all cells by k), and form a DimReduc object in the
         \code{reductions} slot named by argument \code{reduction}.}
     \item{\eqn{W} matrix will be presented as \code{feature.loadings} in the
         same DimReduc object.}
     \item{\eqn{V} matrices, an objective error value and the dataset
         variable used for the factorization is currently stored in
         \code{misc} slot of the same DimReduc object.}
 }}
}
}
\description{
\bold{NOT STABLE} - This is an experimental function and is subject to change.

Performs consensus integrative non-negative matrix factorization (c-iNMF)
to return factorized \eqn{H}, \eqn{W}, and \eqn{V} matrices. In order to
address the non-convex nature of NMF, we built on the cNMF method proposed by
D. Kotliar, 2019. We run the regular iNMF multiple times with different
random starts, and cluster the pool of all the factors in \eqn{W} and
\eqn{V}s and take the consensus of the clusters of the largest population.
The cell factor loading \eqn{H} matrices are eventually solved
with the consensus \eqn{W} and \eqn{V} matrices.

Please see \code{\link{runINMF}} for detailed introduction to the regular
iNMF algorithm which is run multiple times in this function.

The consensus iNMF algorithm is developed basing on the consensus NMF (cNMF)
method (D. Kotliar et al., 2019).
}
\examples{
\donttest{
pbmc <- normalize(pbmc)
pbmc <- selectGenes(pbmc)
pbmc <- scaleNotCenter(pbmc)
if (requireNamespace("RcppPlanc", quietly = TRUE)) {
    pbmc <- runCINMF(pbmc)
}
}
}
\references{
Joshua D. Welch and et al., Single-Cell Multi-omic Integration Compares and
Contrasts Features of Brain Cell Identity, Cell, 2019

Dylan Kotliar and et al., Identifying gene expression programs of cell-type
identity and cellular activity with single-cell RNA-Seq, eLife, 2019
}
