% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{louvainCluster}
\alias{louvainCluster}
\title{Louvain algorithm for community detection}
\usage{
louvainCluster(
  object,
  resolution = 1,
  k = 20,
  prune = 1/15,
  eps = 0.1,
  nRandomStarts = 10,
  nIterations = 100,
  random.seed = 1,
  verbose = TRUE,
  dims.use = NULL
)
}
\arguments{
\item{object}{\code{liger} object. Should run quantile_norm before calling.}

\item{resolution}{Value of the resolution parameter, use a value above (below) 1.0 if you want
to obtain a larger (smaller) number of communities. (default 1.0)}

\item{k}{The maximum number of nearest neighbours to compute. (default 20)}

\item{prune}{Sets the cutoff for acceptable Jaccard index when
computing the neighborhood overlap for the SNN construction. Any edges with
values less than or equal to this will be set to 0 and removed from the SNN
graph. Essentially sets the strigency of pruning (0 --- no pruning, 1 ---
prune everything). (default 1/15)}

\item{eps}{The error bound of the nearest neighbor search. (default 0.1)}

\item{nRandomStarts}{Number of random starts. (default 10)}

\item{nIterations}{Maximal number of iterations per random start. (default 100)}

\item{random.seed}{Seed of the random number generator. (default 1)}

\item{verbose}{Print messages (TRUE by default)}

\item{dims.use}{Indices of factors to use for Louvain clustering (default 1:ncol(H[[1]])).}
}
\value{
\code{liger} object with refined 'clusters' slot set.
}
\description{
After quantile normalization, users can additionally run the Louvain algorithm
for community detection, which is widely used in single-cell analysis and excels at merging
small clusters into broad cell classes.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
ligerex <- optimizeALS(ligerex, k = 5, max.iters = 1)
ligerex <- quantile_norm(ligerex)
ligerex <- louvainCluster(ligerex, resolution = 0.3)
}
