% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{getFactorMarkers}
\alias{getFactorMarkers}
\title{Find shared and dataset-specific markers}
\usage{
getFactorMarkers(
  object,
  dataset1 = NULL,
  dataset2 = NULL,
  factor.share.thresh = 10,
  dataset.specificity = NULL,
  log.fc.thresh = 1,
  pval.thresh = 0.05,
  num.genes = 30,
  print.genes = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{liger} object. Should call optimizeALS before calling.}

\item{dataset1}{Name of first dataset (default first dataset by order)}

\item{dataset2}{Name of second dataset (default second dataset by order)}

\item{factor.share.thresh}{Use only factors with a dataset specificity less than or equalt to
threshold (default 10).}

\item{dataset.specificity}{Pre-calculated dataset specificity if available. Will calculate if not
available.}

\item{log.fc.thresh}{Lower log-fold change threshold for differential expression in markers
(default 1).}

\item{pval.thresh}{Upper p-value threshold for Wilcoxon rank test for gene expression
(default 0.05).}

\item{num.genes}{Max number of genes to report for each dataset (default 30).}

\item{print.genes}{Print ordered markers passing logfc, umi and frac thresholds (default FALSE).}

\item{verbose}{Print messages (TRUE by default)}
}
\value{
List of shared and specific factors. First three elements are dataframes of dataset1-
  specific, shared, and dataset2-specific markers. Last two elements are tables indicating the
  number of factors in which marker appears.
}
\description{
Applies various filters to genes on the shared (W) and dataset-specific (V) components of the
factorization, before selecting those which load most significantly on each factor (in a shared
or dataset-specific way).
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
ligerex <- optimizeALS(ligerex, k = 5, max.iter = 2)
ligerex <- quantile_norm(ligerex)
fm <- getFactorMarkers(ligerex, dataset1 = "stim", dataset2 = "ctrl")
}
