% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{runTSNE}
\alias{runTSNE}
\title{Perform t-SNE dimensionality reduction}
\usage{
runTSNE(
  object,
  use.raw = FALSE,
  dims.use = 1:ncol(object@H.norm),
  use.pca = FALSE,
  perplexity = 30,
  theta = 0.5,
  method = "Rtsne",
  fitsne.path = NULL,
  rand.seed = 42
)
}
\arguments{
\item{object}{\code{liger} object. Should run quantile_norm before calling with defaults.}

\item{use.raw}{Whether to use un-aligned cell factor loadings (H matrices) (default FALSE).}

\item{dims.use}{Factors to use for computing tSNE embedding (default 1:ncol(H.norm)).}

\item{use.pca}{Whether to perform initial PCA step for Rtsne (default FALSE).}

\item{perplexity}{Parameter to pass to Rtsne (expected number of neighbors) (default 30).}

\item{theta}{Speed/accuracy trade-off (increase for less accuracy), set to 0.0 for exact TSNE
(default 0.5).}

\item{method}{Supports two methods for estimating tSNE values: Rtsne (Barnes-Hut implementation
of t-SNE) and fftRtsne (FFT-accelerated Interpolation-based t-SNE) (using Kluger Lab
implementation). (default Rtsne)}

\item{fitsne.path}{Path to the cloned FIt-SNE directory (ie. '/path/to/dir/FIt-SNE') (required
for using fftRtsne -- only first time runTSNE is called) (default NULL).}

\item{rand.seed}{Random seed for reproducibility (default 42).}
}
\value{
\code{liger} object with tsne.coords slot set.
}
\description{
Runs t-SNE on the normalized cell factors (or raw cell factors) to generate a 2D embedding for
visualization. Has option to run on subset of factors. Note that running multiple times will
reset tsne.coords values.
}
\details{
In order to run fftRtsne (recommended for large datasets), you must first install FIt-SNE as
detailed \href{https://github.com/KlugerLab/FIt-SNE}{here}. Include the path to the cloned
FIt-SNE directory as the fitsne.path parameter, though this is only necessary for the first call
to runTSNE. For more detailed FIt-SNE installation instructions, see the liger repo README.
}
\examples{
\dontrun{
# ligerex (liger object), factorization complete
# generate H.norm by quantile normalizig factor loadings
ligerex <- quantile_norm(ligerex)
# get tsne.coords for normalized data
ligerex <- runTSNE(ligerex)
# get tsne.coords for raw factor loadings
ligerex <- runTSNE(ligerex, use.raw = TRUE)
}
}
