% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-keops_grad.R
\name{keops_grad}
\alias{keops_grad}
\title{Compute the gradient of a rkeops operator}
\usage{
keops_grad(operator, var)
}
\arguments{
\item{operator}{a function returned by \code{keops_kernel} implementing a
formula.}

\item{var}{a text string or an integer number indicating regarding to which
variable/parameter (given by name or by position starting at 0) the
gradient of the formula should be computed.}
}
\value{
a function that can be used to compute the value of the formula
on actual data. This function takes as input a list of data corresponding
to the formula arguments and return the computed values (generally a
vector or a matrix depending on the reduction). It has an additional integer
input parameter \code{inner_dim} indicating if the inner dimension
(c.f. \code{browseVignettes("rkeops")}) corresponds to columns, i.e.
\code{inner_dim=1} (default), or rows, i.e. \code{inner_dim=0}, in the data.
}
\description{
The function \code{keops_grad} defines a new operator that is a partial derivative
from a previously defined KeOps operator supplied as input regarding a
specified input variable of this operator.
}
\details{
The use of the function \code{keops_grad} is detailed in the vignettes.
Run \code{browseVignettes("rkeops")} to access the vignettes.

KeOps gradient operators are defined based on KeOps formula and on operator
\code{Grad}. The function \code{keops_grad} is a wrapper to define a new formula
deriving the gradient of the formula associated to a previously defined
operator. The user just needs to choose regarding which variable (given by
name or by position starting at 0), they want to compute the partial
derivative.

The function \code{keops_grad} then calls the function \code{\link[rkeops:keops_kernel]{rkeops::keops_kernel()}}
to compile a new operator corresponding to the partial derivative of the
input operator.

To decide regarding which variable the input operator should be derived,
you can specify its name or its position starting as 0 with the input
parameter \code{var}.
}
\examples{
\donttest{
formula <- "Sum_Reduction(SqNorm2(x-y), 0)"
args <- c("x=Vi(0,3)", "y=Vj(1,3)")
op <- keops_kernel(formula, args)
grad_op <- keops_grad(op, var=0)
}
}
\seealso{
\code{\link[rkeops:keops_kernel]{rkeops::keops_kernel()}}
}
\author{
Ghislain Durif
}
