% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths_and_pointer.R
\name{jsonpath}
\alias{jsonpath}
\alias{jmespath}
\alias{jsonpointer}
\title{JSONpath, JMESpath, or JSONpointer query of JSON / NDJSON
documents; use \code{j_query()} instead}
\usage{
jsonpath(data, path, object_names = "asis", as = "string", ...)

jmespath(data, path, object_names = "asis", as = "string", ...)

jsonpointer(data, path, object_names = "asis", as = "string", ...)
}
\arguments{
\item{data}{a character() JSON string or NDJSON records, or the
name of a file or URL containing JSON or NDJSON, or an \emph{R}
object parsed to a JSON string using \code{jsonlite::toJSON()}.}

\item{path}{character(1) JSONpointer, JSONpath or JMESpath query
string.}

\item{object_names}{character(1) order \code{data} object elements
\code{"asis"} (default) or \code{"sort"} before filtering on \code{path}.}

\item{as}{character(1) return type. \code{"string"} returns a single
JSON string; \code{"R"} returns an \emph{R} object following the rules
outlined for \code{as_r()}.}

\item{...}{arguments for parsing NDJSON, or passed to \code{jsonlite::toJSON} when
\code{data} is not character-valued. For NDJSON,
\itemize{
\item Use \code{n_records = 2} to parse just the first two records of the
NDJSON document.
\item Use \code{verbose = TRUE} to obtain a progress bar when reading from a
connection (file or URL). Requires the cli package.
}

As an example for use with \code{jsonlite::toJSON()}
\itemize{
\item use \code{auto_unbox = TRUE} to automatically 'unbox' vectors of
length 1 to JSON scalar values.
}}
}
\value{
\code{jsonpath()}, \code{jmespath()} and \code{jsonpointer()} return a
character(1) JSON string (\code{as = "string"}, default) or \emph{R}
object (\code{as = "R"}) representing the result of the query.
}
\description{
\code{jsonpath()} executes a query against a JSON string or
vector NDJSON entries using the 'JSONpath' specification.

\code{jmespath()} executes a query against a JSON string
using the 'JMESpath' specification.

\code{jsonpointer()} extracts an element from a JSON string
using the 'JSON pointer' specification.
}
\examples{
json <- '{
  "locations": [
    {"name": "Seattle", "state": "WA"},
    {"name": "New York", "state": "NY"},
    {"name": "Bellevue", "state": "WA"},
    {"name": "Olympia", "state": "WA"}
  ]
 }'

## return a JSON string
jsonpath(json, "$..name") |>
    cat("\n")

## return an R object
jsonpath(json, "$..name", as = "R")

## create a list with state and name as scalar vectors
lst <- as_r(json)

if (requireNamespace("jsonlite", quietly = TRUE)) {
## objects other than scalar character vectors are automatically
## coerced to JSON; use `auto_unbox = TRUE` to represent R scalar
## vectors in the object as JSON scalar vectors
jsonpath(lst, "$..name", auto_unbox = TRUE) |>
    cat("\n")

## use I("Seattle") to coerce to a JSON object ["Seattle"]
jsonpath(I("Seattle"), "$[0]")      |> cat("\n")
}

## a scalar character vector like "Seattle" is not valid JSON...
try(jsonpath("Seattle", "$"))
## ...but a double-quoted string is
jsonpath('"Seattle"', "$")

## different ordering of object names -- 'asis' (default) or 'sort'
json_obj <- '{"b": "1", "a": "2"}'
jsonpath(json_obj, "$")           |> cat("\n")
jsonpath(json_obj, "$.*")         |> cat("\n")
jsonpath(json_obj, "$", "sort")   |> cat("\n")
jsonpath(json_obj, "$.*", "sort") |> cat("\n")

path <- "locations[?state == 'WA'].name | sort(@)"
jmespath(json, path) |>
    cat("\n")

if (requireNamespace("jsonlite", quietly = TRUE)) {
## original filter always fails, e.g., '["WA"] != 'WA'
jmespath(lst, path)  # empty result set, '[]'

## filter with unboxed state, and return unboxed name
jmespath(lst, "locations[?state[0] == 'WA'].name[0] | sort(@)") |>
    cat("\n")

## automatically unbox scalar values when creating the JSON string
jmespath(lst, path, auto_unbox = TRUE) |>
    cat("\n")
}

## jsonpointer 0-based arrays
jsonpointer(json, "/locations/0/name")

## document root "", sort selected element keys
jsonpointer('{"b": 0, "a": 1}', "", "sort", as = "R") |>
    str()

## 'Key not found' -- path '/' searches for a 0-length key
try(jsonpointer('{"b": 0, "a": 1}', "/"))

}
