% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geographic_divisions.R
\name{geographic_divisions}
\alias{geographic_divisions}
\title{Get geographic divisions from tsn}
\usage{
geographic_divisions(tsn, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{tsn}{TSN for a taxonomic group (numeric). Required.}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Get geographic divisions from tsn
}
\examples{
\dontrun{
geographic_divisions(tsn = 180543)

geographic_divisions(tsn = 180543, wt = "xml")

geographic_divisions(tsn = 180543, wt = "json", raw = TRUE)
}
}
