% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsid2tsn.R
\name{lsid2tsn}
\alias{lsid2tsn}
\title{Gets the TSN corresponding to the LSID, or an empty result if there is no match.}
\usage{
lsid2tsn(lsid, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{lsid}{(character) lsid for a taxonomic group. Required.}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Gets the TSN corresponding to the LSID, or an empty result if there is no match.
}
\examples{
\dontrun{
lsid2tsn(lsid="urn:lsid:itis.gov:itis_tsn:28726")
lsid2tsn(lsid="urn:lsid:itis.gov:itis_tsn:28726", wt = "xml")
lsid2tsn("urn:lsid:itis.gov:itis_tsn:0")
lsid2tsn("urn:lsid:itis.gov:itis_tsn:0", wt = "xml")
}
}

