% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_package_host_info.R
\name{check_and_fetch_cran_package}
\alias{check_and_fetch_cran_package}
\title{Check and Fetch CRAN Package}
\usage{
check_and_fetch_cran_package(package_name, package_version = NULL)
}
\arguments{
\item{package_name}{A character string specifying the name of the package to check and fetch.}

\item{package_version}{An optional character string specifying the version of the package to fetch. Defaults to `NULL`.}
}
\value{
A list containing:
  - `package_url`: URL to download the package tarball.
  - `last_version`: Latest version available
  - `version`: The requested version of the package (or `NULL` if not specified).
  - `all_versions`: A character vector of all available package versions
  - `error`: If the package or version is not found, an error message is included.
}
\description{
This function checks if a package exists on CRAN and retrieves the corresponding package URL and version details.
If a specific version is not provided, the latest version is used.
}
\examples{
\dontrun{
# Check and fetch a specific version of "ggplot2"
result <- check_and_fetch_cran_package("ggplot2", package_version = "3.3.5")
print(result)
}
}
