% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c.R
\name{str_c}
\alias{str_c}
\title{Join multiple strings into one string}
\usage{
str_c(..., sep = "", collapse = NULL)
}
\arguments{
\item{...}{One or more character vectors.

\code{NULL}s are removed; scalar inputs (vectors of length 1) are recycled to
the common length of vector inputs.

Like most other R functions, missing values are "infectious": whenever
a missing value is combined with another string the result will always
be missing. Use \code{\link[dplyr:coalesce]{dplyr::coalesce()}} or \code{\link[=str_replace_na]{str_replace_na()}} to convert to
the desired value.}

\item{sep}{String to insert between input vectors.}

\item{collapse}{Optional string used to combine output into single
string. Generally better to use \code{\link[=str_flatten]{str_flatten()}} if you needed this
behaviour.}
}
\value{
If \code{collapse = NULL} (the default) a character vector with
length equal to the longest input. If \code{collapse} is a string, a character
vector of length 1.
}
\description{
\code{str_c()} combines multiple character vectors into a single character
vector. It's very similar to \code{\link[=paste0]{paste0()}} but uses tidyverse recycling and
\code{NA} rules.

One way to understand how \code{str_c()} works is picture a 2d matrix of strings,
where each argument forms a column. \code{sep} is inserted between each column,
and then each row is combined together into a single string. If \code{collapse}
is set, it's inserted between each row, and then the result is again
combined, this time into a single string.
}
\examples{
str_c("Letter: ", letters)
str_c("Letter", letters, sep = ": ")
str_c(letters, " is for", "...")
str_c(letters[-26], " comes before ", letters[-1])

str_c(letters, collapse = "")
str_c(letters, collapse = ", ")

# Differences from paste() ----------------------
# Missing inputs give missing outputs
str_c(c("a", NA, "b"), "-d")
paste0(c("a", NA, "b"), "-d")
# Use str_replace_NA to display literal NAs:
str_c(str_replace_na(c("a", NA, "b")), "-d")

# Uses tidyverse recycling rules
\dontrun{str_c(1:2, 1:3)} # errors
paste0(1:2, 1:3)

str_c("x", character())
paste0("x", character())
}
