% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl-class.R
\name{unclass_tbl}
\alias{unclass_tbl}
\alias{reclass_tbl}
\alias{as_ptype}
\title{Internal utilities for ICU data objects}
\usage{
unclass_tbl(x)

reclass_tbl(x, template, stop_on_fail = TRUE)

as_ptype(x)
}
\arguments{
\item{x}{Object to modify/query}

\item{template}{Object after which to model the object in question}

\item{stop_on_fail}{Logical flag indicating whether to consider failed
object validation as error}
}
\value{
\itemize{
\item \code{unclass_tbl()}: a \code{data.table}
\item \code{reclass_tbl()}: either an \code{id_tbl} or a \code{ts_tbl} depending on the type
of the object passed as \code{template}
\item \code{as_ptype()}: an object of the same type as \code{x}, but with on data
}
}
\description{
In order to remove all \code{id_tbl}/\code{ts_tbl}-related attributes, as well as
extra class-labels, the exported but marked internal function
\code{unclass_tbl()} can be used. This function provides what one might expect
from an \code{id_tbl}/\code{ts_tbl}-specific implementation of the S3 generic
function \code{\link[data.table:as.data.table]{data.table::as.data.table()}}. The inverse functionality if
provided by \code{reclass_tbl()} which attempts to add attributes as seen in
\code{template} to the object passed as \code{x}. The logical flag \code{stop_on_fail}
controls how to proceed if the attributes of \code{template} are incompatible
with the object \code{x}. Finally, in order to generate a template, \code{as_ptype()}
creates an empty object with the appropriate attributes.
}
\keyword{internal}
