\name{gx.add.chisq}
\alias{gx.add.chisq}
\title{ Function to Add Fences to Chi-square Plots }
\description{ This is an internal function used to plot fences at stated probability levels on a Chi-square plot to assist in the assessment of the plotted distribution.  By default fences are plotted for the 90th, 95th and 98th percentiles of the Chi-square distribution.  The function is called from \code{gx.md.plt0}, itself called from \code{gx.md.plot} that is used to display Chi-square plots generated by \code{gx.mva}, \code{robmva} and \code{gx.md.gait}.  
}
\usage{
gx.add.chisq(p = c(0.98, 0.95, 0.9), df = NULL, ifflip = FALSE,
	cex = 0.6)
}
\arguments{
  \item{p}{ the percentiles of the Chi-square distribution for the fences to be displayed, by default the 90th, 95th and 98th percentiles.  If no fences are required set \code{p = NULL}. }
  \item{df}{ the degrees of freedom for the Chi-square distribution, the number of variables in the multivariate distribution. }
  \item{ifflip}{ by default fence labelling is placed to the left of the fences just above the x-axis.  Setting \code{ifflip = TRUE} places the annotation to the right. }
  \item{cex}{ the scale expansion factor for the fence labelling, by default \code{cex = 0.6}. }
}
\author{ Robert G. Garrett }
\seealso{ \code{\link{gx.md.plot}}, \code{\link{gx.md.gait}} }
\examples{
##  Synthesize test data
test <- mvrnorm(100, mu = c(40 ,30),Sigma = matrix(c(6, 3, 3, 2), 2, 2))

## Display annotated Chi-square plot
gx.md.gait(test)
gx.md.gait(test, ifadd = c(0.9, 0.98))

## Clean-up
rm(test)
}
\keyword{ aplot }

