\name{gx.2dproj}
\alias{gx.2dproj}
\title{ Function to Compute and Display 2-d Projections for Data Matrices }
\description{
Function computes and displays 2-d projections of data matrices using either Sammon Non-linear Mapping (default), Multidimensional Scaling, Kruskal's non-metric Multidimensional Scaling (see Venables and Ripley (2001) and Cox and Cox (2001)).  The original S-Plus implementation also computed the Minimum Spanning Tree plane projection (Friedman and Rafsky, 1981) as it was available in the Venables and Ripley MASS library for S-Plus.  However, the R implememntation of the MASS library does not include Minimum Spanning Trees.  In the R implementation, Projection Pursuit has been added using the fastICA procedure of Hyvarinen and Oja (2000).
}
\usage{
gx.2dproj(xx, proc = "sam", log = FALSE, rsnd = FALSE, snd = FALSE,
	range = FALSE, main = "", setseed = FALSE, ...)
}
\arguments{
  \item{xx}{ the n by p matrix for which the 2-d projection is required. }
  \item{proc}{ the 2-d projection procedure required, the default is \code{proc = "sam"} for Sammon Non-Linear Mapping.  For Classic (metric) Multidimensional Scaling use \code{proc = "mds"}, for Kruskal's non-metric Multidimensional Scaling use \code{"iso"}, and for Projection Pursuit use \code{"ica"}. }
  \item{log}{ optional (natural) log transformation of the data, the default is no log transformation.  For a log transformation set \code{log = TRUE}. } 
  \item{rsnd}{ optional robust normalization of the data with matrix column medians and MADs, the default is no transformation.  For a robust normalization set \code{rsnd = TRUE}. }
  \item{snd}{ optional normalization of the data with matrix column means and standard deviations, the default is no transformation.  For a normalization set \code{snd = TRUE}.  If \code{rsnd = TRUE}, then \code{snd} will be set to \code{FALSE}. }
  \item{range}{ optional range transformation for the matrix columns, the data values being scaled to between zero and one for, respectively, the minimum and maximum column values.  If the data are range transformed, other normalization transformation requests will be ignored. }
  \item{main}{ an alternative plot title, see Details below. }
  \item{setseed}{ sets the random number seed for \code{fastICA} so that all runs result in the same projection, and that projection is generally similar to the Sammon projection on the \code{ilr} transformed Howarth - Sinding-Larsen data set. } 
  \item{\dots}{ further arguments to be passed to methods concerning the generated plots.  For example, if smaller plotting characters are required, specify \code{cex = 0.8}; or if some colour other than black is required for the plotting characters, specify \code{col = 2} to obtain red (see \code{\link{display.lty}} for the default colour palette).  If it is required to make the plot title smaller, add \code{cex.main = 0.9} to reduce the font size by 10\%. }
}
\details{
If \code{main} is undefined a default plot title is generated by appending the input matrix name to the text string \code{"2-d Projection for: "}.  If no plot title is required set \code{main = " "}, or if a user defined plot title is required it should be defined in \code{main}, e.g., \code{main = "Plot Title Text"}.

It is desirable to normalize, centre and scale, or undertake a range transformation on the data.  If no transformation is requested a warning message is displayed.  For closed compositional, geochemical, data sets an ilr transformation is recommended, which can be done in the function call, see the Example below.  This also has the effect of reducing the dimension of the data matrix from p to (p-1).

The x- and y-axis labels are set appropriately to indicated the type of 2-d projection in the display.

A measure of the \sQuote{stress} in generating the 2-d projection is estimated and displayed, low stress indicates the projection faithfully represents the relative \sQuote{positions} of the data in the original p-space.
}
\value{
The following are returned as an object to be saved for further use:
  \item{main}{ the plot title. }
  \item{usage}{ a text string containing the name of the n by p matrix containing the data, the projection option, the values, TRUE or FALSE, for the log, robust normalization, normalization, and range transformation options. }
  \item{xlab}{ the 2-d projection x-axis label. }
  \item{ylab}{ the 2-d projection y-axis label. }
  \item{matnames}{ the names of the input variables and row numbers.  Note if an ilr transform has been used the variable names will be the (p-1) synthetic ilr variable names. }
  \item{x}{ the n x-axis values for the 2-d projection. }
  \item{x}{ the n y-axis values for the 2-d projection. }
  \item{stress}{ the estimated stress of fitting 2-d projection to the p-space data. }
}
\note{
Any less than detection limit values represented by negative values, or zeros or other numeric codes representing blanks in the data matrix, must be removed prior to executing this function, see \code{\link{ltdl.fix.df}}.

Any rows in the data matrix with with \code{NA}s are removed prior to computing the 2-d projection.  In the instance of an ilr transformation \code{NA}s have to be removed prior to undertaking the transformation, see \code{\link{remove.na}}.

The results of repeated executions of the \sQuote{fastICA} implementation of Projection Pursuit lead to various mirror images of one another unless \code{set.seed} is used to ensure each execution commences with the same seed.

This function requires that packages MASS (Venables and Ripley) and fastICA (Marchini, Heaton and Ripley) both be available.
}
\references{
Cox, T.F. and Cox, M.A.A., 2001. Multidimensional Scaling. Chapman and Hall, 308 p.

Friedman, J.H. and Rafsky, L.C., 1981. Graphics for the multivariate two-sample problem.  Journal of the American Statistical Association, 76(374):277-291.

Hyvarinen, A. and Oja, E., 2000. Independent Component Analysis: Algorithms and Applications. Neural Networks, 13(4-5):411-430.

Reimann, C., Filzmoser, P., Garrett, R. and Dutter, R., 2008. Statistical Data Analysis Explained: Applied Environmental Statistics with R. John Wiley & Sons, Ltd., 362 p.

Venables, W.N. and Ripley, B.D., 2001. Modern Applied Statistics with S-Plus, 3rd Edition. Springer, 501 p.
}
\author{ Robert G. Garrett }
\seealso{ \code{\link{ltdl.fix.df}}, \code{\link{remove.na}}, \code{\link{gx.2dproj.plot}}, \code{\link{sammon}}, \code{\link{cmdscale}}, \code{\link{isoMDS}}, \code{\link{fastICA}}, \code{\link{set.seed}} }
\examples{
## Make test data available
data(sind.mat2open)

## Display default, Sammon non-linear map, 2-d projection
sind.save <- gx.2dproj(ilr(sind.mat2open))

## Display saved object identifying input matrix row numbers (cex = 0.7),
## and with an alternate main title (cex.main = 0.8) 
gx.2dproj.plot(sind.save, idplot = TRUE, cex = 0.7, cex.main = 0.8,
	main = "Howarth & Sinding-Larsen\nStream Sediment ilr Transformed Data")

## Display Kruskal's non-metric multidimensional scaling 2-d projection
sind.save <- gx.2dproj(ilr(sind.mat2open), proc = "iso")

## Display saved object identifying input matrix row numbers (cex = 0.7),
## and with an alternate main title (cex.main = 0.8) 
gx.2dproj.plot(sind.save, idplot = TRUE, cex = 0.7, cex.main = 0.8, 
	main = "Howarth & Sinding-Larsen\nStream Sediment ilr Transformed Data")

## Clean-up
rm(sind.save)
}
\keyword{ multivariate }
\keyword{ hplot }

