\name{expit}
\alias{expit}
\title{ Inverse-logit transformation(s) }
\description{
Undertakes an inverse-logit transformation for a vector or single value. }
\usage{
expit(z)
}
\arguments{
  \item{z}{ the value(s) to be inverse-logit transformed.  Natural logarithms are used. }
}
\details{
Most analytical chemical data for major, minor and trace elements are of a closed form, i.e. for a sample they sum to a constant, whether it be percent, ppm (mg/kg), or some other units.  It does not matter that only some components contributing to the constant sum are present in the matrix, the data are closed.  As a result, as some elements increase in concentration others must decrease, this leads to statistics and graphical presentations that do not reflect the true underlying situation even in situations of univariate data analysis and display.  Procedures for removing closure effects for multivariate data are additive log-ratios (\code{\link{alr}}), centred log-ratios (\code{\link{clr}}), and isometric log-ratios (\code{\link{ilr}}).
}
\value{
  \item{p}{ the proportion(s) corresponding to the logit transformed value(s), \code{z}, passed to the function. }
}
\note{
This function is provided so that summary statistics generated by \sQuote{rgr} functions can be back-transformed to the original units following computations using logit transformed data, see \code{\link{logit}}.
}
\references{
Filzmoser, P., Hron, K. and Reimann, C., 2009. Univariate statistical analysis of environmental (compositional) data: Problems and possibilities. Science of the Total Environment, 407(1/3):6100-6108.
}
\author{ Robert G. Garrett }
\seealso{ \code{\link{logit}}, \code{\link{alr}}, \code{\link{clr}}, \code{\link{ilr}} }
\examples{
## Generate test data
z <- c(1.6, 0, -2.3)

## Undertake and display inverse-logit transformation(s)
p <- expit(z)
p

## Clean-up
rm(z)
rm(p)
}
\keyword{ univariate }
\keyword{ manip }

