% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gads_get_campaigns.R
\name{gads_get_campaigns}
\alias{gads_get_campaigns}
\title{Get Campaigns Dictionary From Google Ads Client Account}
\usage{
gads_get_campaigns(
  fields = c("campaign.id", "campaign.name", "campaign.accessible_bidding_strategy",
    "campaign.ad_serving_optimization_status", "campaign.advertising_channel_sub_type",
    "campaign.advertising_channel_type", "campaign.app_campaign_setting.app_id",
    "campaign.app_campaign_setting.app_store", "campaign.base_campaign",
    "campaign.bidding_strategy",
    "campaign.app_campaign_setting.bidding_strategy_goal_type",
    "campaign.campaign_budget", "campaign.bidding_strategy_type",
    "campaign.dynamic_search_ads_setting.language_code", 
     "campaign.start_date",
    "campaign.end_date", "campaign.status", "campaign.manual_cpm", "campaign.manual_cpv",
    "campaign.maximize_conversion_value.target_roas",
    "campaign.maximize_conversions.target_cpa",
    "campaign.network_settings.target_content_network",
    "campaign.network_settings.target_google_search",
    "campaign.network_settings.target_partner_search_network",
    "campaign.network_settings.target_search_network",
    "campaign.optimization_goal_setting.optimization_goal_types",
    "campaign.optimization_score", 
     "campaign.payment_mode",
    "campaign.serving_status", "campaign.shopping_setting.campaign_priority",
    "campaign.shopping_setting.sales_country", "campaign.target_roas.target_roas",
    "campaign.tracking_url_template", "customer.descriptive_name", "customer.id"),
  where = NULL,
  order_by = NULL,
  limit = NULL,
  parameters = NULL,
  customer_id = getOption("gads.customer.id"),
  login_customer_id = getOption("gads.login.customer.id"),
  include_resource_name = FALSE,
  cl = NULL,
  verbose = TRUE
)
}
\arguments{
\item{fields}{character vector, list of report fields, all report has own fields list, for example \href{https://developers.google.com/google-ads/api/fields/v10/campaign}{see field list of campaigns report}.}

\item{where}{Filter, for example you can filter campaigns by status \code{where = "campaign.status = 'ENABLED'"}.}

\item{order_by}{Sorting, character vectors of fields and sorting directions, for example \code{order_by = c("campaign.name DESC", "metrics.clicks")}.}

\item{limit}{Maximun rows in report}

\item{parameters}{Query parameters, for example \code{parameters = "include_drafts=true"}.}

\item{customer_id}{Google Ads client customer id, supports a single account id: "xxx-xxx-xxxx" or a vector of ids from the same Google Ads MCC: c("xxx-xxx-xxxx", "xxx-xxx-xxxx")}

\item{login_customer_id}{Google Ads manager customer id}

\item{include_resource_name}{Get resource names fields in report}

\item{cl}{A cluster object created by \code{\link{makeCluster}}, or an integer to indicate number of child-processes (integer values are ignored on Windows) for parallel evaluations (see Details on performance).}

\item{verbose}{Console log output}
}
\value{
tibble with campaings dicrionary
}
\description{
Get Campaigns Dictionary From Google Ads Client Account
}
\examples{
\dontrun{
# set client customer id
gads_set_login_customer_id('xxx-xxx-xxxx')

# set manager id if you work under MCC
gads_set_customer_id('xxx-xxx-xxxx')

# load campaing list
camps <- gads_get_campaigns(
    where = "campaign.status = 'ENABLED'"
)

}
}
\seealso{
\href{https://developers.google.com/google-ads/api/fields/v10/campaign_query_builder}{Google Ads Query Builder}
}
