% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulation.R
\name{add.gexf.node}
\alias{add.gexf.node}
\alias{add.gexf.edge}
\alias{rm.gexf.node}
\alias{rm.gexf.edge}
\alias{add.node.spell}
\alias{add.edge.spell}
\title{Adding and removing nodes/edges from \code{gexf} objects}
\usage{
add.gexf.node(
  graph,
  id = NA,
  label = NA,
  start = NULL,
  end = NULL,
  vizAtt = list(color = NULL, position = NULL, size = NULL, shape = NULL, image = NULL),
  atts = NULL
)

add.gexf.edge(
  graph,
  source,
  target,
  id = NULL,
  type = NULL,
  label = NULL,
  start = NULL,
  end = NULL,
  weight = 1,
  vizAtt = list(color = NULL, thickness = NULL, shape = NULL),
  atts = NULL,
  digits = getOption("digits")
)

rm.gexf.node(graph, id = NULL, number = NULL, rm.edges = TRUE)

rm.gexf.edge(graph, id = NULL, number = NULL)

add.node.spell(
  graph,
  id = NULL,
  number = NULL,
  start = NULL,
  end = NULL,
  digits = getOption("digits")
)

add.edge.spell(
  graph,
  id = NULL,
  number = NULL,
  start = NULL,
  end = NULL,
  digits = getOption("digits")
)
}
\arguments{
\item{graph}{A gexf-class object.}

\item{id}{A node/edge id (normally numeric value).}

\item{label}{A node/edge label.}

\item{start}{Starting time period}

\item{end}{Ending time period}

\item{vizAtt}{A list of node/edge viz attributes (see
\code{\link[=write.gexf]{write.gexf()}}).}

\item{atts}{List of attributes, currently ignored.}

\item{source}{Source node's id.}

\item{target}{Target node's id.}

\item{type}{Type of connection (edge).}

\item{weight}{Edge weight.}

\item{digits}{Integer. Number of decimals to keep for nodes/edges sizes. See
\code{\link[=print.default]{print.default()}}}

\item{number}{Index number(s) of a single or a group of nodes or edges.}

\item{rm.edges}{Whether to remove or not existing edges.}
}
\value{
A \code{gexf} object (see \code{\link[=write.gexf]{write.gexf()}}).
}
\description{
Manipulates \code{gexf} objects adding and removing nodes and edges from
both, its dataframe representation and its XML representation.
}
\details{
\code{new.gexf.graph} Creates a new \code{gexf} empty object (0 nodes 0
edges).

\code{add.gexf.node} and \code{add.gexf.edge} allow adding nodes and edges
to a \code{gexf} object (graph) one at a time. \code{rm.gexf.node} and
\code{rm.gexf.edges} remove nodes and edges respectively.

In the case of \code{rm.gexf.node}, by default every edge linked to the node
that is been removed will also be removed (\code{rm.edges = TRUE}).
}
\section{Spells}{

While the \code{start} and \code{end} attributes can be included in nodes and edges,
spells provide a way to represent presence and absence of elements throughout
time.

We can use spells to indicate windows during which the element is present
or not. For example, a node that shows up from time 1 to time two and
re-appears after time four can have two spells:\preformatted{<spell start="1.0" end="2.0">
<spell start="4.0">
}

In the case of the functions \code{add.edge.spell} and \code{add.node.spell}, edges and
nodes to which you want to add spells should already exist.
}

\examples{

if (interactive()) {
  demo(gexfbuildfromscratch)
}

# Creating spells ------------------------------------------------------
g <- new.gexf.graph()

# Adding a few nodes + edges
g <- add.gexf.node(g, id = 0, label = "A")
g <- add.gexf.node(g, id = 1, label = "B")
g <- add.gexf.node(g, id = 2, label = "C")

g <- add.gexf.edge(g, source = 0, target = 1)
g <- add.gexf.edge(g, source = 0, target = 2)

# Now we add spells:
# - Node 0: 1.0 -> 2.0, 3.0 -> Inf
# - edge 1: 1.0 -> 2.0, 3.5 -> Inf
g <- add.node.spell(g, 0, start = 1, end = 2)
g <- add.node.spell(g, 0, start = 3)

g <- add.edge.spell(g, 1, start = 1, end = 2)
g <- add.edge.spell(g, 1, start = 3.5)

g

}
\references{
The GEXF project website: https://gephi.org/gexf/format/
}
\author{
George Vega Yon

Jorge Fabrega Lacoa
}
\keyword{manip}
