% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{save_weights}
\alias{save_weights}
\title{Save Spatial Weights}
\usage{
save_weights(gda_w, id_variable, out_path, layer_name = "")
}
\arguments{
\item{gda_w}{A Weight object}

\item{id_variable}{The id variable (a data.frame) that defines the unique value of each observation when saving a weights file}

\item{out_path}{The path of an output weights file}

\item{layer_name}{(optional) The name of the layer of input dataset}
}
\value{
A boolean value indicates if save successfully or failed
}
\description{
Save spatial weights to a file
}
\examples{
\dontrun{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
queen_w <- queen_weights(guerry)
save_weights(quen_w, guerry_df['CODE_DE'], out_path = '/Users/xun/Downloads/Guerry_r.gal')
}
}
