% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\docType{class}
\name{Weight-class}
\alias{Weight-class}
\alias{Weight}
\title{Weight class (Internally Used)}
\description{
A wrapper class for p_GeoDaWeight class
}
\section{Fields}{

\describe{
\item{\code{gda_w}}{An object of p_GeoDaWeight-class}

\item{\code{is_symmetric}}{If weights matrix is symmetric}

\item{\code{sparsity}}{Sparsity of weights matrix}

\item{\code{min_neighbors}}{Minimum number of neighbors}

\item{\code{max_neighbors}}{Maximum number of neighbors}

\item{\code{num_obs}}{Number of observations}

\item{\code{mean_neighbors}}{Mean number of neighbors}

\item{\code{median_neighbors}}{Median number of neighbors}

\item{\code{has_isolates}}{If the weights matrix has any isolates}
}}

\section{Methods}{

\describe{
\item{\code{GetNeighborWeights(idx)}}{Get weights values of neighbors for idx-th observation, idx starts from 0}

\item{\code{GetNeighbors(idx)}}{Get neighbors for idx-th observation, idx starts from 0}

\item{\code{GetPointer()}}{Get the C++ object pointer (internally used)}

\item{\code{GetSparsity()}}{Get sparsity computed from weights matrix}

\item{\code{HasIsolates()}}{Check if weights matrix has isolates, or if any observation has no neighbors}

\item{\code{IsSymmetric()}}{Check if weights matrix is symmetric}

\item{\code{SaveToFile(out_path, layer_name, id_name, id_values)}}{Save current spatial weights to a file.\cr \cr
out_path: The path of an output weights file \cr
layer_name : The name of the layer of input dataset \cr
id_name : The id name (or field name), which is an associated column contains unique values, that makes sure that the weights are connected to the correct observations in the data table.\cr
id_values : The tuple of values of selected id_name (column/field)}

\item{\code{SetNeighbors(idx, nbrs)}}{Set neighbors for one observation}

\item{\code{SetNeighborsAndWeights(idx, nbrs, nbr_w)}}{Set neighbors with weights values for one observation}

\item{\code{SpatialLag(values)}}{Compute spatial lag values for values of selected variable}

\item{\code{Update(updateStats = TRUE)}}{Update the weights meta data}

\item{\code{initialize(o_gda_w)}}{Constructor with a GeoDaWeight object (internally used)}
}}

