% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{make_spatial}
\alias{make_spatial}
\title{Make Spatial}
\usage{
make_spatial(clusters, w)
}
\arguments{
\item{clusters}{A cluster classification variable (categorical values from a dataframe or values returned from cluster functions)}

\item{w}{An instance of Weight class}
}
\value{
A vector of categorical values (cluster classification)
}
\description{
Make spatially constrained clusters from spatially non-constrained clusters
using the contiguity information from the input weights
}
\examples{
\dontrun{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
data <- guerry[c('Crm_prs','Crm_prp','Litercy','Donatns','Infants','Suicids')]
clusters <- kmeans(5, data)
queen_w <- queen_weights(guerry)
results <- make_spatial(clusters, queen_w)
results
}
}
