% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_check.R
\name{ee_check-tools}
\alias{ee_check-tools}
\alias{ee_check}
\alias{ee_check_python}
\alias{ee_check_python_packages}
\alias{ee_check_credentials}
\title{Interface to check Python and non-R dependencies}
\usage{
ee_check(user = NULL, quiet = FALSE)

ee_check_python(quiet = FALSE)

ee_check_python_packages(quiet = FALSE)

ee_check_credentials(quiet = FALSE)
}
\arguments{
\item{user}{Character. User to check credentials. If it is not defined,
ee_check will skip the check of credentials.}

\item{quiet}{Logical. Suppress info message}
}
\value{
No return value, called for checking non-R rgee dependencies.
}
\description{
R functions for checking Google credentials (Google Earth Engine,
Google Drive and Google Cloud Storage), Python environment and
Third-Party Python Packages used by rgee.
}
\examples{
\dontrun{
library(rgee)

ee_check_python()
ee_check_python_packages()
ee_check_credentials()
ee_check() # put them all together
}
}
\concept{ee_check functions}
