% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-download.R
\name{ee_monitoring}
\alias{ee_monitoring}
\title{Monitoring Earth Engine task progress}
\usage{
ee_monitoring(task, task_time = 5, eeTaskList = FALSE, quiet = FALSE)
}
\arguments{
\item{task}{List generated after a task is started (i.e. after run
\code{ee$batch$Task$start()}) or a character that represents the ID of a EE
task started.}

\item{task_time}{Numeric. How often (in seconds) should a task be polled?}

\item{eeTaskList}{Logical. If \code{TRUE}, all Earth Engine tasks will be
listed.}

\item{quiet}{Logical. Suppress info message}
}
\value{
An \code{ee$batch$Task} object with a state "COMPLETED" or "FAILED"
according to the response of the Earth Engine server.
}
\description{
Monitoring Earth Engine task progress
}
\examples{
\dontrun{
library(rgee)
ee_Initialize()
ee_monitoring(eeTaskList = TRUE)
}
}
\seealso{
Other helper functions: 
\code{\link{ee_help}()},
\code{\link{ee_print}()}
}
\concept{helper functions}
