% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_download_dataset_activity.R
\name{occ_download_dataset_activity}
\alias{occ_download_dataset_activity}
\title{Lists the downloads activity of a dataset}
\usage{
occ_download_dataset_activity(
  dataset,
  limit = 20,
  start = 0,
  curlopts = list(http_version = 2)
)
}
\arguments{
\item{dataset}{(character) A dataset key}

\item{limit}{(integer/numeric) Number of records to return. Default: 20,
Max: 1000}

\item{start}{(integer/numeric) Record number to start at. Default: 0}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{curl::curl_options}
for curl options}
}
\value{
a list with two slots:
\itemize{
\item meta: a single row data.frame with columns: \code{offset}, \code{limit},
\code{endofrecords}, \code{count}
\item results: a tibble with the nested data flattened, with many
columns with the same \code{download.} or \code{download.request.} prefixes
}
}
\description{
Lists the downloads activity of a dataset
}
\note{
see \link{downloads} for an overview of GBIF downloads methods
}
\examples{
\dontrun{
res <- occ_download_dataset_activity("7f2edc10-f762-11e1-a439-00145eb45e9a")
res
res$meta
res$meta$count

# pagination
occ_download_dataset_activity("7f2edc10-f762-11e1-a439-00145eb45e9a",
limit = 3000)
occ_download_dataset_activity("7f2edc10-f762-11e1-a439-00145eb45e9a",
limit = 3, start = 10)
}
}
\seealso{
Other downloads: 
\code{\link{download_predicate_dsl}},
\code{\link{occ_download_cached}()},
\code{\link{occ_download_cancel}()},
\code{\link{occ_download_datasets}()},
\code{\link{occ_download_get}()},
\code{\link{occ_download_import}()},
\code{\link{occ_download_list}()},
\code{\link{occ_download_meta}()},
\code{\link{occ_download_queue}()},
\code{\link{occ_download_wait}()},
\code{\link{occ_download}()}
}
\concept{downloads}
