% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_download_wait.R
\name{occ_download_wait}
\alias{occ_download_wait}
\title{Wait for an occurrence download to be done}
\usage{
occ_download_wait(x, status_ping = 5, curlopts = list(), quiet = FALSE)
}
\arguments{
\item{x}{and object of class \code{occ_download} or downloadkey}

\item{status_ping}{(integer) seconds between each \code{\link[=occ_download_meta]{occ_download_meta()}}
request. default is 5, and cannot be < 3}

\item{curlopts}{(list) curl options, as named list, passed on to
\code{\link[=occ_download_meta]{occ_download_meta()}}}

\item{quiet}{(logical) suppress messages. default: \code{FALSE}}
}
\value{
an object of class \code{occ_download_meta}, see \code{\link[=occ_download_meta]{occ_download_meta()}}
for details
}
\description{
Wait for an occurrence download to be done
}
\note{
\code{\link[=occ_download_queue]{occ_download_queue()}} is similar, but handles many requests
at once; \code{occ_download_wait} handles one request at a time
}
\examples{
\dontrun{
x <- occ_download(
  pred("taxonKey", 9206251),
  pred_in("country", c("US", "MX")),
  pred_gte("year", 1971)
)
res <- occ_download_wait(x)
occ_download_meta(x)

# works also with a downloadkey
occ_download_wait("0000066-140928181241064") 

}
}
\seealso{
Other downloads: 
\code{\link{download_predicate_dsl}},
\code{\link{occ_download_cached}()},
\code{\link{occ_download_cancel}()},
\code{\link{occ_download_dataset_activity}()},
\code{\link{occ_download_datasets}()},
\code{\link{occ_download_get}()},
\code{\link{occ_download_import}()},
\code{\link{occ_download_list}()},
\code{\link{occ_download_meta}()},
\code{\link{occ_download_queue}()},
\code{\link{occ_download}()}
}
\concept{downloads}
