% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chapters-auto.R
\name{ch06}
\alias{ch06}
\alias{ch6}
\title{Print examples of chapter 6 of 'R for Dummies'.}
\usage{
ch06()

ch6()
}
\description{
To print a listing of all examples of a chapter, use \code{ch6()}.
To run all the examples of \code{ch6()}, use \code{example(ch6)}.
}
\examples{
# Chapter 6 - Going on a Date with R

# Working with Dates

xd <- as.Date("2012-07-27")
xd
str(xd)
weekdays(xd)
xd + 7
xd + 0:6
weekdays(xd + 0:6)

startDate <- as.Date("2012-01-01")
xm <- seq(startDate, by="2 months", length.out=6)
xm
 months(xm)
quarters(xm)

Sys.localeconv()

as.Date("27 July 2012", format="\%d \%B \%Y")

as.Date("27/7/12", format="\%d/\%m/\%y")

# Adding Time Information to Dates

apollo <- "July 20, 1969, 20:17:39"
apollo.fmt <- "\%B \%d, \%Y, \%H:\%M:\%S"
xct <- as.POSIXct(apollo, format=apollo.fmt, tz="UTC")
xct

format(xct, "\%d/\%m/\%y")
format(xct, "\%S minutes past \%I \%p, on \%d \%B \%Y")

# Performing Operations on Dates and Times

## Addition and subtraction

24*60*60
xct + 7*86400
xct + 3*60*60
xct - 7*86400
as.Date(xct) - 7

## Comparison of dates

Sys.time()
Sys.time() < xct

dec.start <- as.POSIXct("1950-01-01")
dec <- seq(dec.start, by="10 years", length.out=4)
dec
dec > xct

## Extraction

xlt <- as.POSIXlt(xct)
xlt
xlt$year
xlt$mon
unclass(xlt)









}
\seealso{
\code{\link{toc}}

Other Chapters: \code{\link{ch01}}, \code{\link{ch02}},
  \code{\link{ch03}}, \code{\link{ch04}},
  \code{\link{ch05}}, \code{\link{ch07}},
  \code{\link{ch08}}, \code{\link{ch09}},
  \code{\link{ch10}}, \code{\link{ch11}},
  \code{\link{ch12}}, \code{\link{ch13}},
  \code{\link{ch14}}, \code{\link{ch15}},
  \code{\link{ch16}}, \code{\link{ch17}},
  \code{\link{ch18}}, \code{\link{ch19}},
  \code{\link{ch20}}
}
\concept{Chapters}
