% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfm-plots.R
\name{rfm_bar_chart}
\alias{rfm_bar_chart}
\title{RFM bar chart}
\usage{
rfm_bar_chart(rfm_table, bar_color = "blue",
  xaxis_title = "Monetary Score", sec_xaxis_title = "Frequency Score",
  yaxis_title = " ", sec_yaxis_title = "Recency Score",
  print_plot = TRUE)
}
\arguments{
\item{rfm_table}{An object of class \code{rfm_table}.}

\item{bar_color}{Color of the bars.}

\item{xaxis_title}{X axis title.}

\item{sec_xaxis_title}{Secondary x axis title.}

\item{yaxis_title}{Y axis title.}

\item{sec_yaxis_title}{Secondary y axis title.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
Bar chart.
}
\description{
Examine the distribution of monetary scores for the different
  combinations of frequency and recency scores.
}
\examples{
# using transaction data
analysis_date <- lubridate::as_date('2006-12-31', tz = 'UTC')
rfm_order <- rfm_table_order(rfm_data_orders, customer_id, order_date,
revenue, analysis_date)

# bar chart
rfm_bar_chart(rfm_order)

}
