% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_dynamics.R
\name{length_length}
\alias{length_length}
\alias{popll}
\title{length_length}
\usage{
length_length(species_list, fields = NULL, limit = 200,
  server = getOption("FISHBASE_API", FISHBASE_API), ...)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species").}

\item{fields}{a character vector specifying which fields (columns) should be returned. By default,
all available columns recognized by the parser are returned. This option can be used to the amount
of data transfered over the network if only certain columns are needed.}

\item{limit}{The maximum number of matches from a single API call (e.g. per species). Function
will warn if this needs to be increased, otherwise can be left as is.}

\item{server}{base URL to the FishBase API (by default). For SeaLifeBase, use http://fishbase.ropensci.org/sealifebase}

\item{...}{additional arguments to httr::GET}
}
\value{
a table of lengths
}
\description{
return a table of lengths
}
\details{
This table contains relationships for the conversion of one length type to another for over 8,000
species of fish, derived from different publications, e.g. Moutopoulos and Stergiou (2002) and
Gaygusuz et al (2006), or from fish pictures, e.g. Collette and Nauen (1983), Compagno (1984)
and Randall (1997). The relationships, which always refer to centimeters, may consist either of a
regression linking two length types, of the form:
 Length type (2) = a + b x Length type (1)
Length type (2) = b' x Length type (1)
The available length types are, as elsewhere in FishBase,
TL = total length;
FL = fork length;
SL = standard length;
WD = width (in rays);
OT = other type (to be specified in the Comment field).
When a version of equation (1) is presented, the length range, the number of fish used in the regression,
the sex and the correlation coefficient are presented, if available.
When a version of equation (2) is presented, the range and the correlation coefficient are omitted,
as the ratio in (2) will usually be estimated from a single specimen, or a few fish covering a narrow
range of lengths.
}
\examples{
\dontrun{
length_length("Oreochromis niloticus")
}
}
\references{
http://www.fishbase.org/manual/english/PDF/FB_Book_CBinohlan_Length-Length_RF_JG.pdf
}

