% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R
\name{survey}
\alias{survey}
\alias{is.survey}
\alias{summary.survey}
\title{Create a survey data frame}
\usage{
survey(object = data.frame(), id = "survey_id", filename = NULL, doi = NULL)

is.survey(object)

\method{summary}{survey}(object, ...)
}
\arguments{
\item{object}{A tibble or data frame that contains the survey data.}

\item{id}{A mandatory identifier for the survey.}

\item{filename}{The import file name.}

\item{doi}{Optional document object identifier (doi), can be omitted.}

\item{...}{Arguments passed to summary method.}
}
\value{
A tibble with \code{id},  \code{filename},  \code{doi}
metadata information.
}
\description{
Store the data of a survey in a tibble (data frame) with a unique
survey identifier, import filename, and optional document object identifier.
}
\details{
Whilst you can create a survey object with this helper function, it is most likely that
you will receive it with an importing function, i.e.
\code{\link{read_rds}}, \code{\link{read_spss}} \code{\link{read_dta}}, \code{\link{read_csv}} or
their common wrapper \code{\link{read_survey}}.
}
\examples{
example_survey <- survey(
  object = data.frame(
    rowid = 1:6,
    observations = runif(6)
  ),
  id = "example",
  filename = "no_file"
)
}
\seealso{
Other importing functions: 
\code{\link{is.survey_df}()}
}
\concept{importing functions}
