% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resultant.R
\name{resultant}
\alias{resultant}
\title{Resultant of two polynomials}
\usage{
resultant(qspray1, qspray2, var = 1)
}
\arguments{
\item{qspray1, qspray2}{two \code{qspray} polynomials with at most nine
variables}

\item{var}{integer indicating with respect to which variable the resultant
is desired (e.g. \code{1} for \code{x} and \code{2} for \code{y})}
}
\value{
If both \code{qspray1} and \code{qspray2} are univariate polynomials,
  the function returns a \code{bigq} rational number.
  Otherwise, it returns a \code{qspray} polynomial that does not involve
  the \code{var}-th variable.
}
\description{
Resultant of two polynomials with rational coefficients.
}
\examples{
library(resultant)
x <- qlone(1)
y <- qlone(2)
f <- x^4 - x^3 + x^2 - 2*x*y^2 + y^4
g <- x - 2*y^2
resultant(f, g, var = 1)
resultant(f, g, var = 2)
}
