/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.set;

import java.util.Arrays;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.delta.ISetDelta;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.delta.SetDelta;
import org.chocosolver.solver.variables.delta.monitor.SetDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.solver.variables.view.SetView;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class SetBoolsView<B extends BoolVar>
extends SetView<B> {
    private final int offset;
    private final ISet lb;
    private final ISet ub;
    protected boolean reactOnModification;
    private ISetDelta delta;

    protected SetBoolsView(String name, int offset, B ... variables) {
        super(name, variables);
        this.offset = offset;
        this.lb = SetFactory.makeStoredSet(SetType.BITSET, 0, variables[0].getModel());
        this.ub = SetFactory.makeStoredSet(SetType.BITSET, 0, variables[0].getModel());
        for (int i = 0; i < variables.length; ++i) {
            if (variables[i].isInstantiatedTo(1)) {
                this.lb.add(i + offset);
            }
            if (!variables[i].contains(1)) continue;
            this.ub.add(i + offset);
        }
    }

    public SetBoolsView(int offset, B ... variables) {
        this("BOOLS_SET_VIEW[" + String.join((CharSequence)",", (CharSequence[])Arrays.stream(variables).map(i -> i.getName()).toArray(String[]::new)) + "]", offset, (BoolVar[])variables);
    }

    @Override
    protected boolean doRemoveSetElement(int element) throws ContradictionException {
        if (((BoolVar[])this.getVariables())[element - this.offset].instantiateTo(0, this)) {
            this.ub.remove(element);
            if (this.reactOnModification) {
                this.delta.add(element, 1, this);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean doForceSetElement(int element) throws ContradictionException {
        if (((BoolVar[])this.getVariables())[element - this.offset].instantiateTo(1, this)) {
            this.lb.add(element);
            if (this.reactOnModification) {
                this.delta.add(element, 0, this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        if (((BoolVar[])this.getVariables())[variableIdx].isInstantiatedTo(1)) {
            this.lb.add(variableIdx + this.offset);
            if (this.reactOnModification) {
                this.delta.add(variableIdx + this.offset, 0, this);
            }
            this.notifyPropagators(SetEventType.ADD_TO_KER, this);
        } else if (((BoolVar[])this.getVariables())[variableIdx].isInstantiatedTo(0)) {
            this.ub.remove(variableIdx + this.offset);
            if (this.reactOnModification) {
                this.delta.add(variableIdx + this.offset, 1, this);
            }
            this.notifyPropagators(SetEventType.REMOVE_FROM_ENVELOPE, this);
        }
    }

    @Override
    public ISet getLB() {
        return this.lb;
    }

    @Override
    public ISet getUB() {
        return this.ub;
    }

    @Override
    public boolean instantiateTo(int[] value, ICause cause) throws ContradictionException {
        boolean changed = !this.isInstantiated();
        ISet s = SetFactory.makeConstantSet(Arrays.stream(value).map(i -> i - this.offset).toArray());
        for (int i2 = 0; i2 < this.getNbObservedVariables(); ++i2) {
            BoolVar var = ((BoolVar[])this.getVariables())[i2];
            if (s.contains(i2)) {
                this.lb.add(i2 + this.offset);
                var.instantiateTo(1, this);
                continue;
            }
            this.ub.remove(i2 + this.offset);
            var.instantiateTo(0, this);
        }
        return changed;
    }

    @Override
    public boolean isInstantiated() {
        for (BoolVar var : (BoolVar[])this.getVariables()) {
            if (var.isInstantiated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ISetDelta getDelta() {
        return this.delta;
    }

    @Override
    public void createDelta() {
        if (!this.reactOnModification) {
            this.reactOnModification = true;
            this.delta = new SetDelta(this.model.getEnvironment());
        }
    }

    @Override
    public ISetDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new SetDeltaMonitor(this.getDelta(), propagator);
    }
}

