/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.basic;

import gnu.trove.list.array.TIntArrayList;
import java.util.BitSet;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropDiameter
extends Propagator<GraphVar> {
    private final GraphVar g;
    private final IntVar diameter;
    private final BitSet visited;
    private final TIntArrayList set;
    private final TIntArrayList nextSet;

    public PropDiameter(GraphVar graph, IntVar maxDiam) {
        super((Variable[])new GraphVar[]{graph}, (Priority)PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.diameter = maxDiam;
        this.visited = new BitSet(this.g.getNbMaxNodes());
        this.set = new TIntArrayList();
        this.nextSet = new TIntArrayList();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int minDiam = this.computeLB();
        if (this.g.isInstantiated()) {
            this.diameter.instantiateTo(minDiam, this);
        } else {
            int nbEdges = this.nbEdgesUB();
            this.diameter.updateLowerBound(minDiam, this);
            this.diameter.updateUpperBound(nbEdges, this);
        }
    }

    private int computeLB() {
        if (this.g.getMandatoryNodes().size() <= 1) {
            return 0;
        }
        return this.bfsLB();
    }

    private int bfsLB() {
        int maxDepth = 0;
        ISetIterator iSetIterator = this.g.getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            int source = (Integer)iSetIterator.next();
            boolean[] visited = new boolean[this.g.getNbMaxNodes()];
            int[] queue = new int[this.g.getNbMaxNodes()];
            int front = 0;
            int rear = 0;
            int[] depth = new int[this.g.getNbMaxNodes()];
            depth[source] = 0;
            queue[front] = source;
            ++rear;
            while (front != rear) {
                int current = queue[front++];
                visited[current] = true;
                ISetIterator iSetIterator2 = this.g.getPotentialSuccessorsOf(current).iterator();
                while (iSetIterator2.hasNext()) {
                    int i = (Integer)iSetIterator2.next();
                    if (visited[i]) continue;
                    depth[i] = depth[current] + 1;
                    if (this.g.getMandatoryNodes().contains(i)) {
                        maxDepth = Math.max(maxDepth, depth[i]);
                    }
                    queue[rear++] = i;
                    visited[i] = true;
                }
            }
        }
        return maxDepth;
    }

    private int nbEdgesUB() {
        int nbEdges = 0;
        ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            nbEdges += this.g.getPotentialSuccessorsOf(i).size();
        }
        if (this.g instanceof UndirectedGraphVar) {
            nbEdges /= 2;
        }
        return nbEdges;
    }

    @Override
    public ESat isEntailed() {
        int minDiam = this.computeLB();
        int nbEdges = this.nbEdgesUB();
        if (minDiam > this.diameter.getUB() || nbEdges < this.diameter.getLB()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            if (minDiam == this.diameter.getValue()) {
                return ESat.TRUE;
            }
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }
}

