% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_cache.R
\name{get_eurostat_cache}
\alias{get_eurostat_cache}
\title{Load an object from cache}
\usage{
get_eurostat_cache(oname, cache_dir = NULL, verbose = FALSE)
}
\arguments{
\item{oname}{a character string with the name of the object (toc, dataset id, DSD id)}

\item{cache_dir}{a path to a cache directory to search in. The default is \code{NULL}, 
in this case the object is searched in the memory (in the '.restatapi_env'). Otherwise
if the \code{cache_dir} directory does not exist it searches the 'restatapi' directory
in the temporary directory from \code{tempdir()}. Directory can also be set with \code{options(restatapi_cache_dir=...)}.}

\item{verbose}{A boolean with default \code{FALSE}, so detailed messages (for debugging) will not printed.
Can be set also with \code{options(restatapi_verbose=TRUE)}}
}
\value{
The requested object if exists in the '.restatapi_env' or in the \code{cache_dir}, otherwise it returns the \code{NULL} value.
}
\description{
Search and load the object (dataset/toc/DSD) from cache
}
\details{
If the given name or the beginning of the name (for datasets) found in the cache then it returns the value of the object otherwise it returns \code{NULL}.
}
\examples{
\dontshow{
options(mc.cores=min((parallel::detectCores()),2))
}
dt<-data.frame(txt=c("a","b","c"),nr=c(1,2,3))
put_eurostat_cache(dt,"teszt")
get_eurostat_cache("teszt",verbose=TRUE)


}
