% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{predgprdp}
\alias{predgprdp}
\title{Prediction function for the \code{gprdp} function (Gaussian process regression with dot product covariance)}
\usage{
predgprdp(Xz, alpha, newdata, scale, Xcenter, Xscale, Ycenter, Yscale)
}
\arguments{
\item{Xz}{the final (scaled?) matrix of predictors used to create the regression model in the \code{gprdp} function}

\item{alpha}{the alpha matrix corresponding to the regression model in the \code{gprdp} function}

\item{newdata}{a \code{matrix} containing the predictor variables}

\item{scale}{a logical indicating whether the matrix of predictors used to create the regression model 
(in the \code{gprdp} function) was scaled}

\item{Xcenter}{if \code{center = TRUE} a \code{matrix} of one row with the values that must be used for centering \code{newdata}.}

\item{Xscale}{if \code{scale = TRUE} a \code{matrix} of one row with the values that must be used for scaling \code{newdata}.}

\item{Ycenter}{if \code{center = TRUE} a \code{matrix} of one row with the values that must be used for accounting for the centering of the response variable.}

\item{Yscale}{if \code{scale = TRUE} a \code{matrix} of one row with the values that must be used  for accounting for the scaling of the response variable.}
}
\value{
a \code{matrix} of predicted values
}
\description{
Predicts response values based on a model generated by the \code{gprdp} function (Gaussian process regression with dot product covariance). For internal use only!.
}
\author{
Leonardo Ramirez-Lopez
}
\keyword{internal}

