% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertPaths.R
\name{Filenames}
\alias{Filenames}
\alias{Filenames,ANY-method}
\alias{Filenames,environment-method}
\alias{Filenames,list-method}
\alias{Filenames,data.table-method}
\alias{Filenames,Path-method}
\title{Return the filename(s) from a \verb{Raster*} object}
\usage{
Filenames(obj, allowMultiple = TRUE, returnList = FALSE)

\S4method{Filenames}{ANY}(obj, allowMultiple = TRUE, returnList = FALSE)

\S4method{Filenames}{environment}(obj, allowMultiple = TRUE, returnList = FALSE)

\S4method{Filenames}{list}(obj, allowMultiple = TRUE, returnList = FALSE)

\S4method{Filenames}{data.table}(obj, allowMultiple = TRUE, returnList = FALSE)

\S4method{Filenames}{Path}(obj, allowMultiple = TRUE, returnList = FALSE)
}
\arguments{
\item{obj}{A \verb{Raster*} object (i.e., \code{RasterLayer}, \code{RasterStack}, \code{RasterBrick})}

\item{allowMultiple}{Logical. If \code{TRUE}, the default, then all relevant
filenames will be returned, i.e., in cases such as \code{.grd} where multiple files
are required. If \code{FALSE}, then only the first file will be returned,
e.g., \code{filename.grd}, in the case of default Raster format in R.}

\item{returnList}{Default \code{FALSE}. If \code{FALSE}, then return format will be a
character vector. When \code{TRUE}, list or environment objects will return a list
of character strings or vectors. When returned as a character vector, then
the names of objects with >1 filename associated with them will be given a numeric
suffix, which means the name in the returned vector does not match the object in
the list or environment. When returned as a list, their names are preserved.}
}
\value{
A character vector of filenames that are part of the objects passed to \code{obj}.
This returns \code{NULL} is the object is not file-backed or does not have a method
to recover the file-backed filename.
}
\description{
This is mostly just a wrapper around \code{filename} from the \code{raster} package, except that
instead of returning an empty string for a \code{RasterStack} object, it will return a vector of
length >1 for \code{RasterStack}.
}
\details{
New methods can be made for this generic.
}
\author{
Eliot McIntire
}
