% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudOld.R
\name{cloudSyncCacheOld}
\alias{cloudSyncCacheOld}
\title{Sync cloud with local Cache}
\usage{
cloudSyncCacheOld(
  cacheRepo = getOption("reproducible.cachePath"),
  checksumsFileID = NULL,
  cloudFolderID = NULL,
  delete = TRUE,
  upload = TRUE,
  download = !delete,
  ask = getOption("reproducible.ask"),
  cacheIds = NULL,
  ...
)
}
\arguments{
\item{cacheRepo}{See \code{x} in \code{\link{showCache}}}

\item{checksumsFileID}{A google file ID where the checksums data.table is located,
provided as a character string.}

\item{cloudFolderID}{A googledrive dribble of a folder, e.g., using \code{drive_mkdir()}.
If left as \code{NULL}, the function will create a cloud folder with name from last
two folder levels of the \code{cacheRepo} path, :
\code{paste0(basename(dirname(cacheRepo)), "_", basename(cacheRepo))}.
This \code{cloudFolderID} will be added to \code{options("reproducible.cloudFolderID")},
but this will not persist across sessions. If this is a character string, it will
treat this as a folder name to create or use on GoogleDrive.}

\item{delete}{Logical. If \code{TRUE}, the default, it will delete any objects
that are in \code{cloudFolderID} that are absent from local \code{cacheRepo}.
If \code{FALSE}, it will not delete objects.}

\item{upload}{Logical. If \code{TRUE}, the default, it will upload any objects
identified by the internal \code{showCache(...)} call. See examples. If \code{FALSE},
then no files will be uploaded. Can be used in conjunction with \code{delete}
to create behaviours similar to \code{clearCache} and \code{keepCache}.}

\item{download}{Logical. If \code{FALSE}, the default, then the function will
either delete the remote copy if \code{delete = TRUE} and there is no local
copy, or upload the local copy if \code{upload = TRUE} and there is a local
copy. If \code{TRUE}, then this will override \code{delete}, and download
to local machine if it exists remotely.}

\item{ask}{Logical. If \code{FALSE}, then it will not ask to confirm deletions using
\code{clearCache} or \code{keepCache}. Default is \code{TRUE}}

\item{cacheIds}{If supplied, then only this/these cacheId objects
will be uploaded or deleted. Default is \code{NULL}, meaning do
full sync (i.e., match cloudFolder with local cacheRepo, constrained by
\code{delete} or \code{upload})}

\item{...}{Passed to \code{showCache} to get the artifacts to delete.}
}
\description{
This is still experimental, see examples.
}
\details{
\code{cloudSyncCacheOld} will remove any entries in a cloudCache that are not in a
}
\seealso{
\code{\link{cloudCache}}, \code{\link{Cache}}, \code{\link{cloudWriteOld}},
  \code{\link{cloudCheckOld}}
}
