% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcess.R
\name{writeOutputs}
\alias{writeOutputs}
\alias{writeOutputs.Raster}
\alias{writeOutputs.Spatial}
\alias{writeOutputs.sf}
\alias{writeOutputs.default}
\title{Write module inputs on disk}
\usage{
writeOutputs(
  x,
  filename2,
  overwrite = getOption("reproducible.overwrite", NULL),
  ...
)

\method{writeOutputs}{Raster}(
  x,
  filename2 = NULL,
  overwrite = getOption("reproducible.overwrite", FALSE),
  ...
)

\method{writeOutputs}{Spatial}(
  x,
  filename2 = NULL,
  overwrite = getOption("reproducible.overwrite", TRUE),
  ...
)

\method{writeOutputs}{sf}(
  x,
  filename2 = NULL,
  overwrite = getOption("reproducible.overwrite", FALSE),
  ...
)

\method{writeOutputs}{default}(x, filename2, ...)
}
\arguments{
\item{x}{The object save to disk i.e., write outputs}

\item{filename2}{File name passed to \code{\link[raster]{writeRaster}}, or
\code{\link[raster]{shapefile}} or \code{\link[sf]{st_write}}
(\code{dsn} argument).}

\item{overwrite}{Logical. Should file being written overwrite an existing file if it exists.}

\item{...}{Passed into \code{\link[raster]{shapefile}} or
\code{\link[raster]{writeRaster}} or \code{\link[sf]{st_write}}}
}
\description{
Can be used to write prepared inputs on disk.
}
\examples{
# Add a study area to Crop and Mask to
# Create a "study area"
library(sp)
library(raster)
ow <- setwd(tempdir())

# make a SpatialPolygon
coords1 <- structure(c(-123.98, -117.1, -80.2, -100, -123.98, 60.9, 67.73, 65.58, 51.79, 60.9),
                     .Dim = c(5L, 2L))
Sr1 <- Polygon(coords1)
Srs1 <- Polygons(list(Sr1), "s1")
shpEcozone <- SpatialPolygons(list(Srs1), 1L)
crs(shpEcozone) <- "+init=epsg:4326 +proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"

# make a "study area" that is subset of larger dataset
coords <- structure(c(-118.98, -116.1, -99.2, -106, -118.98, 59.9, 65.73, 63.58, 54.79, 59.9),
                    .Dim = c(5L, 2L))
Sr1 <- Polygon(coords)
Srs1 <- Polygons(list(Sr1), "s1")
StudyArea <- SpatialPolygons(list(Srs1), 1L)
crs(StudyArea) <- "+init=epsg:4326 +proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"
#'
#'
##########
shpEcozonePostProcessed <- postProcess(shpEcozone, studyArea = StudyArea)
#'
# Try manually, individual pieces
shpEcozoneReprojected <- projectInputs(shpEcozone, StudyArea)
shpEcozoneCropped <- cropInputs(shpEcozone, StudyArea)
shpEcozoneClean <- fixErrors(shpEcozone)
shpEcozoneMasked <- maskInputs(shpEcozone, StudyArea)

setwd(ow)
}
\author{
Eliot McIntire and Jean Marchal
}
