% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectSize.R
\name{objSize}
\alias{objSize}
\alias{objSize.list}
\alias{objSize.environment}
\alias{objSize.default}
\alias{objSize.Path}
\title{Recursive object.size}
\usage{
objSize(x, quick)

\method{objSize}{list}(x, quick = getOption("reproducible.quick", FALSE))

\method{objSize}{environment}(x, quick = getOption("reproducible.quick",
  FALSE))

\method{objSize}{default}(x, quick = getOption("reproducible.quick", FALSE))

\method{objSize}{Path}(x, quick = getOption("reproducible.quick", FALSE))
}
\arguments{
\item{x}{An object}

\item{quick}{Logical. Only some methods use this. e.g.,
\code{Path} class objects. In which case, \code{file.size} will be
used instead of \code{object.size}.}
}
\description{
This has methods for various types of things that may not correctly report
their object.size using \code{object\.size}. Also, for lists and environments,
it will return the object.size separately for each element.
}
\examples{
a <- new.env()
a$b <- 1:10
a$d <- 1:10

objSize(a) # all the elements in the environment
object.size(a) # different - only measuring the environment as an object
}
\keyword{internal}
