% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{calcCliffdConfidenceIntervals}
\alias{calcCliffdConfidenceIntervals}
\title{calcCliffdConfidenceIntervals}
\usage{
calcCliffdConfidenceIntervals(
  d.value,
  d.variance,
  d.df,
  alpha = 0.05,
  alternative = "two.sided"
)
}
\arguments{
\item{d.value}{This is the value of Cliff's d.}

\item{d.variance}{This is the estimated variance of Cliff's d}

\item{d.df}{The degrees of freedom.}

\item{alpha}{This is the alpha level required for the statistical tests (default 0.05)}

\item{alternative}{This defines whether a one-sided test or a two-sided
(default) test is required. For a one-sided test use parameter values
greater' or 'less' to define whether the d-value should be greater or less
than zero.}
}
\value{
The function returns a Boolean variable identifying whether the effect size is significant and the confidence interval bounds.
}
\description{
This functions is a helper function. It assesses the significance one-sided and two-sided statistical of Cliff's d based on its confidence interval. The type of test is determined by the parameter One.Sided.Tests, the direction of one-sided tests is determined by the parameter Positive.MD.
}
\examples{
reproducer:::calcCliffdConfidenceIntervals(d.value=0.5, d.variance=0.04,d.df=18)
# A tibble: 1 x 5
#  d.tvalue d.pvalue d.ci.lower d.ci.upper d.sig
#     <dbl>    <dbl>      <dbl>      <dbl> <lgl>
#1      2.5   0.0223     0.0479      0.782 TRUE

reproducer:::calcCliffdConfidenceIntervals(
  d.value=0.5,d.variance=0.04,d.df=18,alternative='greater')
# A tibble: 1 x 5
#  d.tvalue d.pvalue d.ci.lower d.ci.upper d.sig
#   <dbl>    <dbl>      <dbl>      <dbl> <lgl>
#1    2.5   0.0112      0.123          1 TRUE

reproducer:::calcCliffdConfidenceIntervals(
  d.value=0.2,d.variance=0.04,d.df=18,alternative='greater')
# A tibble: 1 x 3
#  d.tvalue d.pvalue d.ci.lower d.ci.upper d.sig
#     <dbl>    <dbl>      <dbl>      <dbl> <lgl>
#1        1    0.165     -0.133          1 FALSE

reproducer:::calcCliffdConfidenceIntervals(
  d.value=-0.5,d.variance=0.04,d.df=18,alternative='less')
# A tibble: 1 x 5
#  d.tvalue d.pvalue d.ci.lower d.ci.upper d.sig
#   <dbl>    <dbl>      <dbl>      <dbl> <lgl>
#1     -2.5   0.0112         -1     -0.123 TRUE
}
\author{
Barbara Kitchenham and Lech Madeyski
}
