% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{RandomizedBlocksExperimentSimulations}
\alias{RandomizedBlocksExperimentSimulations}
\title{title RandomizedBlocksExperimentSimulations
description This function performs multiple simulations of 4 group balanced randomised Block experiments with two control groups and two treatment groups where one control group and one treatment group are assigned to block 1 and the other control group and treatment group are assigned to block 2.  The simulations are based on one of four distributions and a specific group size. The function identifies the average value of the non-paramtric effect sizes P-hat, Cliff' d and Kendall's point biserial tau and their variances and whether ot not the statistics were significant at the 0.05 level. We also present the values of the t-test as a comparison.}
\usage{
RandomizedBlocksExperimentSimulations(
  mean,
  sd,
  diff,
  N,
  reps,
  type = "n",
  alpha = 0.05,
  Blockmean = 0,
  BlockStdAdj = 0,
  StdAdj = 0,
  seed = 123,
  returnData = FALSE
)
}
\arguments{
\item{mean}{The default mean for all 4 groups. The default for the two treatment groups can be altered using the parameter diff and the block mean for block 2 can be altered using the parameter Blockmean.}

\item{sd}{The default spread for all 4 groups. It must be a real value greater than 0. If can be altered for treatment groups using the parameter StdAdj and for Block 2 groups using BlockStdAdj}

\item{diff}{The is is added to the parameter mean, to define the mean of the other treatment group. It can be a real value ad can take the value zero.}

\item{N}{this is the number of observations in each group. It must be an interger greater than 3.}

\item{reps}{this identifies the number of tiume the simulation is replicated.}

\item{type}{this specifies the underlying distribution used to generate the data. it takes the values "n" for a normal distribution, "l" for lognormal distribution,"g" for a gamma distribution, "lap" for a Laplace distribution.}

\item{alpha}{is the Type 1 error level used for constructing confidence intervals}

\item{Blockmean}{is the effect of having two different blocks}

\item{BlockStdAdj}{is the variance associated with the Block mean. If Blockvar is zero it means we are treat the block effect as a fixed effect. If BlockStdAdj>0, we treat the block effect as a random effect.}

\item{StdAdj}{The value used to introduce heterogeneity into the treatment groups variance if required.}

\item{seed}{this specifies the seed value for the simulations and allows the experiment to be repeated.}

\item{returnData}{= FALSE if TRUE the function returns the generated data otherwise it returns summary statistics.}
}
\value{
depending on the parameter returnData it returns the generated nonparametric and parametric values or the summary statistics
examples
RandomizedBlocksExperimentSimulations(mean=0,sd=1,diff=0.5,N=10, reps=500,type="n",alpha=0.05,Blockmean=0.5, BlockStdAdj=0,StdAdj=0,seed=123)
# A tibble: 1 x 18
#    phat varphat sigphat emp.phat.var     d   vard  sigd emp.d.var  ktau kconsistentvar emp.tau.var kpowerCVt StdES
#   <dbl>   <dbl>   <dbl>        <dbl> <dbl>  <dbl> <dbl>     <dbl> <dbl>          <dbl>       <dbl>     <dbl> <dbl>
# 1 0.640 0.00832   0.326      0.00773 0.279 0.0343 0.282    0.0309 0.147        0.00956     0.00856     0.168 0.513
#  … with 5 more variables: ES <dbl>, Var <dbl>, emp.StdESvar <dbl>, MedDiff <dbl>, tpower <dbl>
RandomizedBlocksExperimentSimulations(mean=0,sd=1,diff=0.5,N=10, reps=10,type="n",alpha=0.05,Blockmean=0.5, BlockStdAdj=0,StdAdj=0,seed=123,returnData=T)
# A tibble: 10 x 3
#   Cliffd  PHat StdES
#    <dbl> <dbl> <dbl>
# 1  0.58  0.79  1.06
# 3  0.37  0.685 0.761
# 4  0.440 0.72  0.821
# 5  0.13  0.565 0.240
# 6  0.16  0.58  0.222
# 7  0.38  0.69  0.580
# 8  0.48  0.74  0.882
# 9  0.11  0.555 0.181
#10 -0.03  0.485 0.124
}
\description{
title RandomizedBlocksExperimentSimulations
description This function performs multiple simulations of 4 group balanced randomised Block experiments with two control groups and two treatment groups where one control group and one treatment group are assigned to block 1 and the other control group and treatment group are assigned to block 2.  The simulations are based on one of four distributions and a specific group size. The function identifies the average value of the non-paramtric effect sizes P-hat, Cliff' d and Kendall's point biserial tau and their variances and whether ot not the statistics were significant at the 0.05 level. We also present the values of the t-test as a comparison.
}
\author{
Barbara Kitchenham and Lech Madeyski
}
