% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{KitchenhamMadeyskiBrereton.ExpData}
\alias{KitchenhamMadeyskiBrereton.ExpData}
\title{KitchenhamMadeyskiBrereton.ExpData data}
\format{A text file with variables:
\describe{
\item{Study}{This field includes the study identifier of each of the 13 primary studies which were included in the systematic review. }
\item{Exp}{This identifies the experiment to which the descriptive data belongs.}
\item{Source}{Always set to Rep. This identifies that the data was as reported by the primary study authors.}
\item{Mc}{The mean value of the observations obtained using the control technique.}
\item{SDc}{The standard deviation of the observations obtained using the control technique.}
\item{Nc}{The number of participants using the control technique in the first time period.}
\item{Mt}{The mean value of the observations obtained using the treatment technique.}
\item{SDt}{The standard deviation of the observations obtained using the treatment technique.}
\item{Nt}{The number of participants using the treatment technique in the first time period.}
\item{r}{The correlation between repeated measures. NA if not reported. Note only study 13 reported this correlation.}
}}
\source{
\url{http://madeyski.e-informatyka.pl/reproducible-research/}
}
\usage{
KitchenhamMadeyskiBrereton.ExpData
}
\description{
This data is used in the paper: Barbara Kitchenham, Lech Madeyski and Pearl Brereton. Meta-analysis for Families of Experiments: A Systematic Review and Reproducibility Assessment, Empirical Software Engineering (2019) doi:10.1007/s10664-019-09747-0.
This file holds the descriptive data for each experiment which include the mean, standard deviation and sample size for the control and treatment techniques. Note in the case of studies 3, 7 and 11, which reported descriptive data for each time period (or equivalently each document) separately, the values for of the descriptive data were obtained by analysing the data reported in the DocData file.
}
\examples{
KitchenhamMadeyskiBrereton.ExpData

}
\keyword{datasets}
