% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalysisForFamiliesOfExperimentsSR.R
\name{calculateHg}
\alias{calculateHg}
\title{calculateHg}
\usage{
calculateHg(Mc, Mt, Nc, Nt, SDc, SDt)
}
\arguments{
\item{Mc}{is a vector containing the mean value of the control group for each experiment.}

\item{Mt}{is a vector containing the mean value of the treatment group for each experiment.}

\item{Nc}{is a vector containing the the number of observations (particpants) in the control group for each experiment.}

\item{Nt}{is a vector of the number of observations (participants) in the treatment group for each experiment.}

\item{SDc}{is a vector of the standard deviations of the control group for each experiment.}

\item{SDt}{is a vector of the standard deviations of the the treatment group for each experiment.}
}
\value{
data frame composed of Hedges' g and Hedges' g adjusted effect sizes
}
\description{
This function calculates Hedges g and Hedges g adjusted given the basic experimental statistics - the mean values for participants, number of observations (participants), and standard deviation in both the control group and the treatment group. . Hence, the function assumes the data is held as summary statistics including the control group mean, standard deviation and sample size and equivalent values for treatment group
}
\examples{
calculateHg(10, 15, 20, 20, 2, 2)
#    Hg    HgAdjusted
# 1  2.5   2.450276
}
\author{
Barbara Kitchenham and Lech Madeyski
}
