% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{span}
\alias{span}
\title{Defines a spanning header attribute}
\usage{
span(
  from,
  to,
  label = NULL,
  label_align = "center",
  level = 1,
  underline = TRUE
)
}
\arguments{
\item{from}{The starting column to span.  Spanning columns are defined as
range of columns 'from' and 'to'. The columns may be identified by position, 
or by quoted or unquoted variable names. 
The \code{from} parameter is required.}

\item{to}{The ending column to span.  Spanning columns are defined as
range of columns 'from' and 'to'. The columns may be identified by position,
or by quoted or unquoted variable names.  
The \code{to} parameter is required.}

\item{label}{The label to apply to the spanning header.}

\item{label_align}{The alignment to use for the label. Valid values are 
"left", "right", "center", and "centre".  The default for spanning columns
is "center".}

\item{level}{The level to use for the spanning header.  The lowest
spanning level is level 1, the next level above is level 2, and so on.  
By default, the level is set to 1.}

\item{underline}{A TRUE or FALSE value indicating whether the spanning
header should be underlined.  Default is TRUE.}
}
\value{
The spanning header attribute object.
}
\description{
Create a spanning header attribute object that can be
attached to a data frame and passed to the \code{\link{create_table}}
function.  This attribute is used internally by other packages in the 
\strong{r-sassy} system.
}
\details{
A spanning header is a label and underline that spans one or more 
columns.  A spanning header is defined minimally by identifying the
column range to be spanned, and a label.  A label alignment 
may also be supplied.

The spanning column range is defined by the \code{from} and \code{to} 
parameters.  The range identifies a contiguous set of variables on the data.
Variables can be identified by position, a quoted variable name, or an 
unquoted variable name.
}
\seealso{
Other attributes: 
\code{\link{ftn}()},
\code{\link{ttl}()}
}
\concept{attributes}
