% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_set}
\alias{repo_set}
\title{Edit an existing item.}
\usage{
repo_set(rp, name, obj = NULL, newname = NULL, description = NULL,
  tags = NULL, src = NULL, depends = NULL, addtags = NULL)
}
\arguments{
\item{rp}{An object of class repo.}

\item{name}{An item name.}

\item{obj}{An R object to replace the one currently associated with the item.}

\item{newname}{Newname of the item.}

\item{description}{Item's description.}

\item{tags}{New item's tags as a ist of character.}

\item{src}{New item's provenance as a list of character.}

\item{depends}{List of item names indicating dependancies.}

\item{addtags}{Tags to be added to current item's tags. Can not be
used together with the parameter "tags".}
}
\value{
Used for side effects.
}
\description{
Edit an existing item.
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)
rp$put(1, "item1", "Sample item 1", c("tag1", "tag2"))
rp$set("item1", obj=2)
print(rp$get("item1"))
rp$set("item1", description="Modified description", tags="new_tag_set")
rp$info("item1")

## wiping temporary repo
unlink(rp_path, TRUE)
}
\seealso{
repo_put
}

