% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copyToFrom.R
\name{replyr_copy_from}
\alias{replyr_copy_from}
\title{Bring remote data back as a local data frame tbl.}
\usage{
replyr_copy_from(d, maxrow = 1e+06)
}
\arguments{
\item{d}{remote dplyr data item}

\item{maxrow}{max rows to allow (stop otherwise, set to NULL to allow any size).}
}
\value{
local tbl.
}
\description{
Bring remote data back as a local data frame tbl.
}
\examples{


if (requireNamespace("RSQLite", quietly = TRUE) &&
    requireNamespace("dbplyr", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  RSQLite::initExtension(my_db)
  d <- replyr_copy_to(my_db,data.frame(x=c(1,2)),'d')
  d2 <- replyr_copy_from(d)
  print(d2)
  DBI::dbDisconnect(my_db)
}

}
