% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/epijsonObjectVis.R
\name{epijsonObjectVis}
\alias{epijsonObjectVis}
\title{to view the structure of epijson objects and/or schema
allowing multiple attribute boxes with different labels}
\usage{
epijsonObjectVis(attribMeta = "attributes [name, type, value, units]",
  attribRecord = "attributes [name, type, value, units]",
  attribEvent = "attributes [name, type, value, units]",
  labelObject = "Diagram of EpiJSON file structure", labelMeta = "metadata",
  labelRecord = "records [id]",
  labelEvent = "events [id, name, date, location]", colAll = NULL,
  colObject = "gray60", colMeta = "gray60", colRecord = "blue",
  colEvent = "red", colAttrib = "purple", textSize = 4)
}
\arguments{
\item{attribMeta}{label(s) for Metadata attributes}

\item{attribRecord}{label(s) for Record attributes}

\item{attribEvent}{label(s) for Event attributes}

\item{labelObject}{label for the overall object}

\item{labelMeta}{label for Metadata attributes}

\item{labelRecord}{label for Record attributes}

\item{labelEvent}{label for Event attributes}

\item{colAll}{optional single box colour to overide all other col args, e.g. 'grey'}

\item{colObject}{object box colour}

\item{colMeta}{metadata box colour}

\item{colRecord}{record box colour}

\item{colEvent}{event box colour}

\item{colAttrib}{attribute boxes colour}

\item{textSize}{size of labels default=4}
}
\value{
a ggplot object
}
\description{
to view the structure of epijson objects and/or schema
allowing multiple attribute boxes with different labels
}
\examples{
#this gives the base schema
epijsonObjectVis()
#settin single box colour and increasing text size
epijsonObjectVis(colAll ='grey', textSize=7)
#this gives a diagram with named attributes
epijsonObjectVis( attribMeta = c("attribute: disease","attribute: data provider"),
                   attribRecord = c("attribute: gender","attribute: date of birth"),
                   attribEvent = c("attribute: recorder","attribute: test used") )
epijsonObjectVis( attribMeta = c("a"),
                   attribRecord = c("b","c"),
                   attribEvent = c("d","e","f") )
#repijson objects
epijsonObjectVis( attribMeta = 'ejAttribute',
                  attribRecord = 'ejAttribute',
                  attribEvent = 'ejAttribute',
                  labelObject = 'ejObject',
                  labelMeta = 'ejMetadata',
                  labelRecord = 'ejRecord',
                  labelEvent = 'ejEvent')
#repijson objects and constructors
epijsonObjectVis( attribMeta = 'ejAttribute create_ejAttribute()',
                   attribRecord = 'ejAttribute create_ejAttribute()',
                   attribEvent = 'ejAttribute create_ejAttribute()',
                   labelObject = 'repijson R objects and constructors : ejObject create_ejObject()',
                   labelMeta = 'ejMetadata create_ejMetadata()',
                   labelRecord = 'ejRecord create_ejRecord()',
                   labelEvent = 'ejEvent create_ejEvent()')
}

