% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivbetab.r
\name{biv.betab}
\alias{biv.betab}
\title{Bivariate Beta-binomial Regression Models}
\usage{
biv.betab(
  freq,
  x = NULL,
  p,
  depend = TRUE,
  print.level = 0,
  typsize = abs(p),
  ndigit = 10,
  gradtol = 1e-05,
  stepmax = 10 * sqrt(p \%*\% p),
  steptol = 1e-05,
  iterlim = 100,
  fscale = 1
)
}
\arguments{
\item{freq}{A matrix containing four columns corresponding to 00, 01, 10,
and 11 responses.}

\item{x}{A matrix of explanatory variables, containing pairs of columns,
one for each response, and the same number of rows as freq.}

\item{p}{Initial parameter estimates: intercept, dependence (if depend is
TRUE, and one for each pair of columns of x.}

\item{depend}{If FALSE, the independence (logistic) model is fitted.}

\item{print.level}{Arguments for nlm.}

\item{typsize}{Arguments for nlm.}

\item{ndigit}{Arguments for nlm.}

\item{gradtol}{Arguments for nlm.}

\item{stepmax}{Arguments for nlm.}

\item{steptol}{Arguments for nlm.}

\item{iterlim}{Arguments for nlm.}

\item{fscale}{Arguments for nlm.}
}
\value{
A list of class \code{bivbetab} is returned.
}
\description{
\code{biv.betab} fits dependent (logit) linear regression models to a
bivariate beta-binomial distribution.
}
\examples{

y <- matrix(  c( 2, 1, 1,13,
		 4, 1, 3, 5,
		 3, 3, 1, 4,
		15, 8, 1, 6),ncol=4,byrow=TRUE)
first <- c(0,0,1,1)
second <- c(0,1,0,1)
self <- cbind(first,second)
other <- cbind(second,first)
biv.betab(y,cbind(self,other),p=c(-1,2,1,1))
# independence
biv.betab(y,cbind(self,other),p=c(-1,1,1),dep=FALSE)

}
\author{
J.K. Lindsey
}
\keyword{models}
